/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.lang.Nullable;

public class JobParameters
implements Serializable {
    private final Map<String, JobParameter> parameters;

    public JobParameters() {
        this.parameters = new LinkedHashMap<String, JobParameter>();
    }

    public JobParameters(Map<String, JobParameter> parameters) {
        this.parameters = new LinkedHashMap<String, JobParameter>(parameters);
    }

    @Nullable
    public Long getLong(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        Object value = this.parameters.get(key).getValue();
        return value == null ? null : Long.valueOf((Long)value);
    }

    @Deprecated
    public Long getLong(String key, long defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLong(key);
        }
        return defaultValue;
    }

    @Nullable
    public Long getLong(String key, @Nullable Long defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLong(key);
        }
        return defaultValue;
    }

    @Nullable
    public String getString(String key) {
        JobParameter value = this.parameters.get(key);
        return value == null ? null : value.toString();
    }

    @Nullable
    public String getString(String key, @Nullable String defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }

    @Nullable
    public Double getDouble(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        Double value = (Double)this.parameters.get(key).getValue();
        return value == null ? null : Double.valueOf(value);
    }

    @Deprecated
    public Double getDouble(String key, double defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getDouble(key);
        }
        return defaultValue;
    }

    @Nullable
    public Double getDouble(String key, @Nullable Double defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getDouble(key);
        }
        return defaultValue;
    }

    @Nullable
    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    @Nullable
    public Date getDate(String key, @Nullable Date defaultValue) {
        if (this.parameters.containsKey(key)) {
            return (Date)this.parameters.get(key).getValue();
        }
        return defaultValue;
    }

    public Map<String, JobParameter> getParameters() {
        return new LinkedHashMap<String, JobParameter>(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        JobParameters rhs = (JobParameters)obj;
        return this.parameters.equals(rhs.parameters);
    }

    public int hashCode() {
        return 17 + 23 * this.parameters.hashCode();
    }

    public String toString() {
        return this.parameters.toString();
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, JobParameter> param : this.parameters.entrySet()) {
            if (param.getValue() == null) continue;
            props.put(param.getKey(), Objects.toString(param.getValue().toString(), ""));
        }
        return props;
    }
}

