/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.List;
import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.batch.core.jsr.configuration.xml.JsrJobListenerFactoryBean;
import org.springframework.batch.core.jsr.configuration.xml.PropertyParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ListenerParser {
    private static final String REF_ATTRIBUTE = "ref";
    private static final String LISTENER_ELEMENT = "listener";
    private static final String LISTENERS_ELEMENT = "listeners";
    private static final String SCOPE_STEP = "step";
    private static final String SCOPE_JOB = "job";
    private Class<?> listenerType;
    private String propertyKey;

    public ListenerParser(Class<?> listenerType, String propertyKey) {
        this.propertyKey = propertyKey;
        this.listenerType = listenerType;
    }

    public void parseListeners(Element element, ParserContext parserContext, AbstractBeanDefinition bd, String stepName) {
        ManagedList<AbstractBeanDefinition> listeners = this.parseListeners(element, parserContext, stepName);
        if (listeners.size() > 0) {
            bd.getPropertyValues().add(this.propertyKey, listeners);
        }
    }

    public void parseListeners(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedList<AbstractBeanDefinition> listeners = this.parseListeners(element, parserContext, "");
        if (listeners.size() > 0) {
            builder.addPropertyValue(this.propertyKey, listeners);
        }
    }

    private ManagedList<AbstractBeanDefinition> parseListeners(Element element, ParserContext parserContext, String stepName) {
        List listenersElements = DomUtils.getChildElementsByTagName((Element)element, (String)LISTENERS_ELEMENT);
        ManagedList listeners = new ManagedList();
        if (listenersElements.size() == 1) {
            Element listenersElement = (Element)listenersElements.get(0);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            listeners.setMergeEnabled(false);
            List listenerElements = DomUtils.getChildElementsByTagName((Element)listenersElement, (String)LISTENER_ELEMENT);
            for (Element listenerElement : listenerElements) {
                String beanName = listenerElement.getAttribute(REF_ATTRIBUTE);
                BeanDefinitionBuilder bd = BeanDefinitionBuilder.genericBeanDefinition(this.listenerType);
                bd.addPropertyValue("delegate", (Object)new RuntimeBeanReference(beanName));
                this.applyListenerScope(beanName, parserContext.getRegistry());
                listeners.add((Object)bd.getBeanDefinition());
                new PropertyParser(beanName, parserContext, this.getBatchArtifactType(stepName), stepName).parseProperties(listenerElement);
            }
            parserContext.popAndRegisterContainingComponent();
        } else if (listenersElements.size() > 1) {
            parserContext.getReaderContext().error("The '<listeners/>' element may not appear more than once in a single " + element.getLocalName(), (Object)element);
        }
        return listeners;
    }

    protected void applyListenerScope(String beanName, BeanDefinitionRegistry beanDefinitionRegistry) {
        BeanDefinition beanDefinition = this.getListenerBeanDefinition(beanName, beanDefinitionRegistry);
        beanDefinition.setScope(this.getListenerScope());
        beanDefinition.setLazyInit(this.isLazyInit());
        if (!beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            beanDefinitionRegistry.registerBeanDefinition(beanName, beanDefinition);
        }
    }

    private BeanDefinition getListenerBeanDefinition(String beanName, BeanDefinitionRegistry beanDefinitionRegistry) {
        if (beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            return beanDefinitionRegistry.getBeanDefinition(beanName);
        }
        return BeanDefinitionBuilder.genericBeanDefinition((String)beanName).getBeanDefinition();
    }

    private boolean isLazyInit() {
        return this.listenerType == JsrJobListenerFactoryBean.class;
    }

    private String getListenerScope() {
        if (this.listenerType == JsrJobListenerFactoryBean.class) {
            return SCOPE_JOB;
        }
        return SCOPE_STEP;
    }

    private BatchArtifactType getBatchArtifactType(String stepName) {
        return stepName != null && !"".equals(stepName) ? BatchArtifactType.STEP_ARTIFACT : BatchArtifactType.ARTIFACT;
    }
}

