/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.factory;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.factory.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class SimpleStepFactoryBean<T, S>
implements FactoryBean<Step>,
BeanNameAware {
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete;
    private ItemReader<? extends T> itemReader;
    private ItemProcessor<? super T, ? extends S> itemProcessor;
    private ItemWriter<? super S> itemWriter;
    private PlatformTransactionManager transactionManager;
    private Propagation propagation = Propagation.REQUIRED;
    private Isolation isolation = Isolation.DEFAULT;
    private int transactionTimeout = -1;
    private JobRepository jobRepository;
    private boolean singleton = true;
    private ItemStream[] streams = new ItemStream[0];
    private StepListener[] listeners = new StepListener[0];
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int commitInterval = 0;
    private TaskExecutor taskExecutor;
    private RepeatOperations stepOperations;
    private RepeatOperations chunkOperations;
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private CompletionPolicy chunkCompletionPolicy;
    private int throttleLimit = 4;
    private boolean isReaderTransactionalQueue = false;

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.isReaderTransactionalQueue = isReaderTransactionalQueue;
    }

    protected boolean isReaderTransactionalQueue() {
        return this.isReaderTransactionalQueue;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setItemReader(ItemReader<? extends T> itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemWriter(ItemWriter<? super S> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setItemProcessor(ItemProcessor<? super T, ? extends S> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    protected StepListener[] getListeners() {
        return this.listeners;
    }

    protected ItemReader<? extends T> getItemReader() {
        return this.itemReader;
    }

    protected ItemWriter<? super S> getItemWriter() {
        return this.itemWriter;
    }

    protected ItemProcessor<? super T, ? extends S> getItemProcessor() {
        return this.itemProcessor;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected TransactionAttribute getTransactionAttribute() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(this.propagation.value());
        attribute.setIsolationLevel(this.isolation.value());
        attribute.setTimeout(this.transactionTimeout);
        return new DefaultTransactionAttribute((TransactionAttribute)attribute){

            public boolean rollbackOn(Throwable ex) {
                return true;
            }
        };
    }

    public final Step getObject() throws Exception {
        SimpleStepBuilder<T, S> builder = this.createBuilder(this.getName());
        this.applyConfiguration(builder);
        TaskletStep step = builder.build();
        return step;
    }

    protected SimpleStepBuilder<T, S> createBuilder(String name) {
        return new SimpleStepBuilder(new StepBuilder(name));
    }

    public Class<TaskletStep> getObjectType() {
        return TaskletStep.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    protected RepeatOperations getStepOperations() {
        return this.stepOperations;
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setChunkOperations(RepeatOperations chunkOperations) {
        this.chunkOperations = chunkOperations;
    }

    protected RepeatOperations getChunkOperations() {
        return this.chunkOperations;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setThrottleLimit(int throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    protected void applyConfiguration(SimpleStepBuilder<T, S> builder) {
        builder.reader(this.itemReader);
        builder.processor(this.itemProcessor);
        builder.writer(this.itemWriter);
        for (StepExecutionListener stepExecutionListener : BatchListenerFactoryHelper.getListeners(this.listeners, StepExecutionListener.class)) {
            builder.listener(stepExecutionListener);
        }
        for (ChunkListener chunkListener : BatchListenerFactoryHelper.getListeners(this.listeners, ChunkListener.class)) {
            builder.listener(chunkListener);
        }
        for (ItemReadListener itemReadListener : BatchListenerFactoryHelper.getListeners(this.listeners, ItemReadListener.class)) {
            builder.listener(itemReadListener);
        }
        for (ItemWriteListener itemWriteListener : BatchListenerFactoryHelper.getListeners(this.listeners, ItemWriteListener.class)) {
            builder.listener(itemWriteListener);
        }
        for (ItemProcessListener itemProcessListener : BatchListenerFactoryHelper.getListeners(this.listeners, ItemProcessListener.class)) {
            builder.listener(itemProcessListener);
        }
        builder.transactionManager(this.transactionManager);
        builder.transactionAttribute(this.getTransactionAttribute());
        builder.repository(this.jobRepository);
        builder.startLimit(this.startLimit);
        builder.allowStartIfComplete(this.allowStartIfComplete);
        builder.chunk(this.commitInterval);
        builder.chunk(this.chunkCompletionPolicy);
        builder.chunkOperations(this.chunkOperations);
        builder.stepOperations(this.stepOperations);
        builder.taskExecutor(this.taskExecutor);
        builder.throttleLimit(this.throttleLimit);
        builder.exceptionHandler(this.exceptionHandler);
        if (this.isReaderTransactionalQueue) {
            builder.readerIsTransactionalQueue();
        }
        for (Iterator<StepListener> iterator : this.streams) {
            builder.stream((ItemStream)iterator);
        }
    }
}

