/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.context.JobContext;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JsrJobContext
implements JobContext {
    private Object transientUserData;
    private Properties properties;
    private JobExecution jobExecution;
    private AtomicBoolean exitStatusSet = new AtomicBoolean();

    public void setJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"A JobExecution is required");
        this.jobExecution = jobExecution;
    }

    public void setProperties(@Nullable Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    public String getJobName() {
        return this.jobExecution.getJobInstance().getJobName();
    }

    public Object getTransientUserData() {
        return this.transientUserData;
    }

    public void setTransientUserData(Object data) {
        this.transientUserData = data;
    }

    public long getInstanceId() {
        return this.jobExecution.getJobInstance().getId();
    }

    public long getExecutionId() {
        return this.jobExecution.getId();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public BatchStatus getBatchStatus() {
        return this.jobExecution.getStatus().getBatchStatus();
    }

    @Nullable
    public String getExitStatus() {
        return this.exitStatusSet.get() ? this.jobExecution.getExitStatus().getExitCode() : null;
    }

    public void setExitStatus(String status) {
        this.jobExecution.setExitStatus(new ExitStatus(status));
        this.exitStatusSet.set(true);
    }
}

