/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.jsr.configuration.support.JsrExpressionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class JsrBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    private static final String NULL = "null";
    private static final String ROOT_JOB_ELEMENT_NAME = "job";
    private static final String JOB_PROPERTY_ELEMENT_NAME = "property";
    private static final String JOB_PROPERTIES_ELEMENT_NAME = "properties";
    private static final String JOB_PROPERTY_ELEMENT_NAME_ATTRIBUTE = "name";
    private static final String JOB_PROPERTY_ELEMENT_VALUE_ATTRIBUTE = "value";
    private static final String JOB_PROPERTIES_KEY_NAME = "jobProperties";
    private static final String JOB_PARAMETERS_KEY_NAME = "jobParameters";
    private static final String JOB_PARAMETERS_BEAN_DEFINITION_NAME = "jsr_jobParameters";
    private static final Log LOG = LogFactory.getLog(JsrBeanDefinitionDocumentReader.class);
    private static final Pattern PROPERTY_KEY_SEPARATOR = Pattern.compile("'([^']*?)'");
    private static final Pattern OPERATOR_PATTERN = Pattern.compile("(#\\{(job(Properties|Parameters))[^}]+\\})");
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private JsrExpressionParser expressionParser = new JsrExpressionParser();
    private Map<String, Properties> propertyMap = new HashMap<String, Properties>();

    public JsrBeanDefinitionDocumentReader() {
    }

    public JsrBeanDefinitionDocumentReader(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    protected void preProcessXml(Element root) {
        if (ROOT_JOB_ELEMENT_NAME.equals(root.getLocalName())) {
            this.initProperties(root);
            this.transformDocument(root);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Transformed XML from preProcessXml: " + this.elementToString(root)));
            }
        }
    }

    protected void initProperties(Element root) {
        this.propertyMap.put(JOB_PARAMETERS_KEY_NAME, this.initJobParameters());
        this.propertyMap.put(JOB_PROPERTIES_KEY_NAME, this.initJobProperties(root));
        this.resolvePropertyValues(this.propertyMap.get(JOB_PARAMETERS_KEY_NAME));
        this.resolvePropertyValues(this.propertyMap.get(JOB_PROPERTIES_KEY_NAME));
    }

    private Properties initJobParameters() {
        Properties jobParameters = new Properties();
        if (this.getBeanDefinitionRegistry().containsBeanDefinition(JOB_PARAMETERS_BEAN_DEFINITION_NAME)) {
            BeanDefinition beanDefinition = this.getBeanDefinitionRegistry().getBeanDefinition(JOB_PARAMETERS_BEAN_DEFINITION_NAME);
            Properties properties = (Properties)beanDefinition.getConstructorArgumentValues().getGenericArgumentValue(Properties.class).getValue();
            if (properties == null) {
                return new Properties();
            }
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String curName = (String)propertyNames.nextElement();
                jobParameters.put(curName, properties.getProperty(curName));
            }
        }
        return jobParameters;
    }

    private Properties initJobProperties(Element root) {
        Properties properties = new Properties();
        Node propertiesNode = root.getElementsByTagName(JOB_PROPERTIES_ELEMENT_NAME).item(0);
        if (propertiesNode != null) {
            NodeList children = propertiesNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!JOB_PROPERTY_ELEMENT_NAME.equals(child.getLocalName())) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node name = attributes.getNamedItem(JOB_PROPERTY_ELEMENT_NAME_ATTRIBUTE);
                Node value = attributes.getNamedItem(JOB_PROPERTY_ELEMENT_VALUE_ATTRIBUTE);
                properties.setProperty(name.getNodeValue(), value.getNodeValue());
            }
        }
        return properties;
    }

    private void resolvePropertyValues(Properties properties) {
        for (String propertyKey : properties.stringPropertyNames()) {
            String resolvedPropertyValue = this.resolvePropertyValue(properties.getProperty(propertyKey));
            if (properties.getProperty(propertyKey).equals(resolvedPropertyValue)) continue;
            properties.setProperty(propertyKey, resolvedPropertyValue);
        }
    }

    private String resolvePropertyValue(String propertyValue) {
        String resolvedValue = this.resolveValue(propertyValue);
        Matcher jobParameterMatcher = OPERATOR_PATTERN.matcher(resolvedValue);
        while (jobParameterMatcher.find()) {
            resolvedValue = this.resolvePropertyValue(resolvedValue);
        }
        return resolvedValue;
    }

    private String resolveValue(String value) {
        StringBuffer valueBuffer = new StringBuffer();
        Matcher jobParameterMatcher = OPERATOR_PATTERN.matcher(value);
        while (jobParameterMatcher.find()) {
            Matcher jobParameterKeyMatcher = PROPERTY_KEY_SEPARATOR.matcher(jobParameterMatcher.group(1));
            if (!jobParameterKeyMatcher.find()) continue;
            String propertyType = jobParameterMatcher.group(2);
            String extractedProperty = jobParameterKeyMatcher.group(1);
            Properties properties = this.propertyMap.get(propertyType);
            if (properties == null) {
                throw new IllegalArgumentException("Unknown property type: " + propertyType);
            }
            String resolvedProperty = properties.getProperty(extractedProperty, NULL);
            if (NULL.equals(resolvedProperty) && LOG.isInfoEnabled()) {
                LOG.info((Object)(propertyType + " with key of: " + extractedProperty + " could not be resolved. Possible configuration error?"));
            }
            jobParameterMatcher.appendReplacement(valueBuffer, resolvedProperty);
        }
        jobParameterMatcher.appendTail(valueBuffer);
        String resolvedValue = valueBuffer.toString();
        if (NULL.equals(resolvedValue)) {
            return "";
        }
        return this.expressionParser.parseExpression(resolvedValue);
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return this.beanDefinitionRegistry != null ? this.beanDefinitionRegistry : this.getReaderContext().getRegistry();
    }

    private void transformDocument(Element root) {
        DocumentTraversal traversal = (DocumentTraversal)((Object)root.getOwnerDocument());
        NodeIterator iterator = traversal.createNodeIterator(root, 1, null, true);
        BeanDefinitionRegistry registry = this.getBeanDefinitionRegistry();
        HashMap<String, Integer> referenceCountMap = new HashMap<String, Integer>();
        Node n = iterator.nextNode();
        while (n != null) {
            NamedNodeMap map = n.getAttributes();
            if (map.getLength() > 0) {
                for (int i = 0; i < map.getLength(); ++i) {
                    String resolvedValue;
                    Node node = map.item(i);
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    String newNodeValue = resolvedValue = this.resolveValue(nodeValue);
                    if ("ref".equals(nodeName)) {
                        Integer beanDefinition;
                        if (!referenceCountMap.containsKey(resolvedValue)) {
                            referenceCountMap.put(resolvedValue, 0);
                        }
                        boolean isClass = this.isClass(resolvedValue);
                        Integer referenceCount = (Integer)referenceCountMap.get(resolvedValue);
                        if (isClass && !registry.containsBeanDefinition(resolvedValue)) {
                            beanDefinition = BeanDefinitionBuilder.genericBeanDefinition((String)resolvedValue).getBeanDefinition();
                            beanDefinition.setScope("step");
                            registry.registerBeanDefinition(resolvedValue, (BeanDefinition)beanDefinition);
                            newNodeValue = resolvedValue;
                        } else if (registry.containsBeanDefinition(resolvedValue)) {
                            beanDefinition = referenceCount;
                            Integer n2 = referenceCount = Integer.valueOf(referenceCount + 1);
                            referenceCountMap.put(resolvedValue, referenceCount);
                            newNodeValue = resolvedValue + referenceCount;
                            beanDefinition = registry.getBeanDefinition(resolvedValue);
                            registry.registerBeanDefinition(newNodeValue, (BeanDefinition)beanDefinition);
                        }
                    }
                    if (nodeValue.equals(newNodeValue)) continue;
                    node.setNodeValue(newNodeValue);
                }
            } else {
                String resolvedValue;
                String nodeValue = n.getTextContent();
                if (!nodeValue.equals(resolvedValue = this.resolveValue(nodeValue))) {
                    n.setTextContent(resolvedValue);
                }
            }
            n = iterator.nextNode();
        }
    }

    private boolean isClass(String className) {
        try {
            Class.forName(className, false, ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    protected Properties getJobParameters() {
        return this.propertyMap.get(JOB_PARAMETERS_KEY_NAME);
    }

    protected Properties getJobProperties() {
        return this.propertyMap.get(JOB_PROPERTIES_KEY_NAME);
    }

    private String elementToString(Element root) {
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)root.getOwnerDocument().getImplementation());
        return domImplLS.createLSSerializer().writeToString(root);
    }
}

