/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;

public class DefaultJobKeyGenerator
implements JobKeyGenerator<JobParameters> {
    @Override
    public String generateKey(JobParameters source) {
        Assert.notNull((Object)source, (String)"source must not be null");
        Map<String, JobParameter<?>> props = source.getParameters();
        StringBuilder stringBuffer = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(props.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            JobParameter<?> jobParameter = props.get(key);
            if (!jobParameter.isIdentifying()) continue;
            String value = jobParameter.toString();
            stringBuffer.append(key).append("=").append(value).append(";");
        }
        try {
            return DigestUtils.md5DigestAsHex((byte[])stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }
}

