/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class JobParametersBuilder {
    private Map<String, JobParameter<?>> parameterMap;
    private JobExplorer jobExplorer;

    public JobParametersBuilder() {
        this.parameterMap = new LinkedHashMap();
    }

    public JobParametersBuilder(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
        this.parameterMap = new LinkedHashMap();
    }

    public JobParametersBuilder(JobParameters jobParameters) {
        this(jobParameters, null);
    }

    public JobParametersBuilder(JobParameters jobParameters, JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
        this.parameterMap = new LinkedHashMap(jobParameters.getParameters());
    }

    public JobParametersBuilder addString(String key, @NonNull String parameter) {
        return this.addString(key, parameter, true);
    }

    public JobParametersBuilder addString(String key, @NonNull String parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter<String>(parameter, String.class, identifying));
        return this;
    }

    public JobParametersBuilder addDate(String key, @NonNull Date parameter) {
        return this.addDate(key, parameter, true);
    }

    public JobParametersBuilder addDate(String key, @NonNull Date parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter<Date>(parameter, Date.class, identifying));
        return this;
    }

    public JobParametersBuilder addLocalDate(String key, @NonNull LocalDate parameter) {
        return this.addLocalDate(key, parameter, true);
    }

    public JobParametersBuilder addLocalDate(String key, @NonNull LocalDate parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter<LocalDate>(parameter, LocalDate.class, identifying));
        return this;
    }

    public JobParametersBuilder addLocalTime(String key, @NonNull LocalTime parameter) {
        return this.addLocalTime(key, parameter, true);
    }

    public JobParametersBuilder addLocalTime(String key, @NonNull LocalTime parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter<LocalTime>(parameter, LocalTime.class, identifying));
        return this;
    }

    public JobParametersBuilder addLocalDateTime(String key, @NonNull LocalDateTime parameter) {
        return this.addLocalDateTime(key, parameter, true);
    }

    public JobParametersBuilder addLocalDateTime(String key, @NonNull LocalDateTime parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter<LocalDateTime>(parameter, LocalDateTime.class, identifying));
        return this;
    }

    public JobParametersBuilder addLong(String key, @NonNull Long parameter) {
        return this.addLong(key, parameter, true);
    }

    public JobParametersBuilder addLong(String key, @NonNull Long parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter<Long>(parameter, Long.class, identifying));
        return this;
    }

    public JobParametersBuilder addDouble(String key, @NonNull Double parameter) {
        return this.addDouble(key, parameter, true);
    }

    public JobParametersBuilder addDouble(String key, @NonNull Double parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter<Double>(parameter, Double.class, identifying));
        return this;
    }

    public JobParameters toJobParameters() {
        return new JobParameters(this.parameterMap);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public JobParametersBuilder addParameter(String key, JobParameter<?> jobParameter) {
        Assert.notNull(jobParameter, (String)"JobParameter must not be null");
        this.parameterMap.put(key, jobParameter);
        return this;
    }

    public JobParametersBuilder addJobParameter(String key, JobParameter<?> jobParameter) {
        Assert.notNull(jobParameter, (String)"JobParameter must not be null");
        this.parameterMap.put(key, jobParameter);
        return this;
    }

    public <T> JobParametersBuilder addJobParameter(String name, T value, Class<T> type, boolean identifying) {
        return this.addJobParameter(name, new JobParameter<T>(value, type, identifying));
    }

    public <T> JobParametersBuilder addJobParameter(String name, T value, Class<T> type) {
        return this.addJobParameter(name, value, type, true);
    }

    public JobParametersBuilder addJobParameters(JobParameters jobParameters) {
        Assert.notNull((Object)jobParameters, (String)"jobParameters must not be null");
        this.parameterMap.putAll(jobParameters.getParameters());
        return this;
    }

    public JobParametersBuilder getNextJobParameters(Job job) {
        JobExecution previousExecution;
        Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer is required to get next job parameters");
        Assert.notNull((Object)job, (String)"Job must not be null");
        Assert.notNull((Object)job.getJobParametersIncrementer(), (String)("No job parameters incrementer found for job=" + job.getName()));
        String name = job.getName();
        JobInstance lastInstance = this.jobExplorer.getLastJobInstance(name);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        JobParameters nextParameters = lastInstance == null ? incrementer.getNext(new JobParameters()) : ((previousExecution = this.jobExplorer.getLastJobExecution(lastInstance)) == null ? incrementer.getNext(new JobParameters()) : incrementer.getNext(previousExecution.getJobParameters()));
        HashMap nextParametersMap = new HashMap(nextParameters.getParameters());
        nextParametersMap.putAll(this.parameterMap);
        this.parameterMap = nextParametersMap;
        return this;
    }
}

