/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.NoSuchObjectException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcJobExecutionDao
extends AbstractJdbcBatchMetadataDao
implements JobExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JdbcJobExecutionDao.class);
    private static final String SAVE_JOB_EXECUTION = "INSERT into %PREFIX%JOB_EXECUTION(JOB_EXECUTION_ID, JOB_INSTANCE_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, VERSION, CREATE_TIME, LAST_UPDATED) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CHECK_JOB_EXECUTION_EXISTS = "SELECT COUNT(*) FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID = ?";
    private static final String GET_STATUS = "SELECT STATUS from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String UPDATE_JOB_EXECUTION = "UPDATE %PREFIX%JOB_EXECUTION set START_TIME = ?, END_TIME = ?,  STATUS = ?, EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ?, CREATE_TIME = ?, LAST_UPDATED = ? where JOB_EXECUTION_ID = ? and VERSION = ?";
    private static final String FIND_JOB_EXECUTIONS = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ? order by JOB_EXECUTION_ID desc";
    private static final String GET_LAST_EXECUTION = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION from %PREFIX%JOB_EXECUTION E where JOB_INSTANCE_ID = ? and JOB_EXECUTION_ID in (SELECT max(JOB_EXECUTION_ID) from %PREFIX%JOB_EXECUTION E2 where E2.JOB_INSTANCE_ID = ?)";
    private static final String GET_EXECUTION_BY_ID = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String GET_RUNNING_EXECUTIONS = "SELECT E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, E.JOB_INSTANCE_ID from %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID and I.JOB_NAME=? and E.STATUS in ('STARTING', 'STARTED', 'STOPPING')";
    private static final String CURRENT_VERSION_JOB_EXECUTION = "SELECT VERSION FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID=?";
    private static final String FIND_PARAMS_FROM_ID = "SELECT JOB_EXECUTION_ID, PARAMETER_NAME, PARAMETER_TYPE, PARAMETER_VALUE, IDENTIFYING from %PREFIX%JOB_EXECUTION_PARAMS where JOB_EXECUTION_ID = ?";
    private static final String CREATE_JOB_PARAMETERS = "INSERT into %PREFIX%JOB_EXECUTION_PARAMS(JOB_EXECUTION_ID, PARAMETER_NAME, PARAMETER_TYPE, PARAMETER_VALUE, IDENTIFYING) values (?, ?, ?, ?, ?)";
    private static final String DELETE_JOB_EXECUTION = "DELETE FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID = ?";
    private static final String DELETE_JOB_EXECUTION_PARAMETERS = "DELETE FROM %PREFIX%JOB_EXECUTION_PARAMS WHERE JOB_EXECUTION_ID = ?";
    private int exitMessageLength = 2500;
    private DataFieldMaxValueIncrementer jobExecutionIncrementer;
    private ConfigurableConversionService conversionService = new DefaultConversionService();

    public void setExitMessageLength(int exitMessageLength) {
        this.exitMessageLength = exitMessageLength;
    }

    public void setJobExecutionIncrementer(DataFieldMaxValueIncrementer jobExecutionIncrementer) {
        this.jobExecutionIncrementer = jobExecutionIncrementer;
    }

    public void setConversionService(@NonNull ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.jobExecutionIncrementer != null ? 1 : 0) != 0, (String)"The jobExecutionIncrementer must not be null.");
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance job) {
        Assert.notNull((Object)job, (String)"Job cannot be null.");
        Assert.notNull((Object)job.getId(), (String)"Job Id cannot be null.");
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_EXECUTIONS), (RowMapper)new JobExecutionRowMapper(job), new Object[]{job.getId()});
    }

    @Override
    public void saveJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        jobExecution.setId(this.jobExecutionIncrementer.nextLongValue());
        Timestamp startTime = jobExecution.getStartTime() == null ? null : Timestamp.valueOf(jobExecution.getStartTime());
        Timestamp endTime = jobExecution.getEndTime() == null ? null : Timestamp.valueOf(jobExecution.getEndTime());
        Timestamp createTime = jobExecution.getCreateTime() == null ? null : Timestamp.valueOf(jobExecution.getCreateTime());
        Timestamp lastUpdated = jobExecution.getLastUpdated() == null ? null : Timestamp.valueOf(jobExecution.getLastUpdated());
        Object[] parameters = new Object[]{jobExecution.getId(), jobExecution.getJobId(), startTime, endTime, jobExecution.getStatus().toString(), jobExecution.getExitStatus().getExitCode(), jobExecution.getExitStatus().getExitDescription(), jobExecution.getVersion(), createTime, lastUpdated};
        this.getJdbcTemplate().update(this.getQuery(SAVE_JOB_EXECUTION), parameters, new int[]{-5, -5, 93, 93, 12, 12, 12, 4, 93, 93});
        this.insertJobParameters(jobExecution.getId(), jobExecution.getJobParameters());
    }

    private void validateJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"jobExecution cannot be null");
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution Job-Id cannot be null.");
        Assert.notNull((Object)((Object)jobExecution.getStatus()), (String)"JobExecution status cannot be null.");
        Assert.notNull((Object)jobExecution.getCreateTime(), (String)"JobExecution create time cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        Assert.notNull((Object)jobExecution.getId(), (String)"JobExecution ID cannot be null. JobExecution must be saved before it can be updated");
        Assert.notNull((Object)jobExecution.getVersion(), (String)"JobExecution version cannot be null. JobExecution must be saved before it can be updated");
        JobExecution jobExecution2 = jobExecution;
        synchronized (jobExecution2) {
            Integer version = jobExecution.getVersion() + 1;
            String exitDescription = jobExecution.getExitStatus().getExitDescription();
            if (exitDescription != null && exitDescription.length() > this.exitMessageLength) {
                exitDescription = exitDescription.substring(0, this.exitMessageLength);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Truncating long message before update of JobExecution: " + jobExecution));
                }
            }
            Timestamp startTime = jobExecution.getStartTime() == null ? null : Timestamp.valueOf(jobExecution.getStartTime());
            Timestamp endTime = jobExecution.getEndTime() == null ? null : Timestamp.valueOf(jobExecution.getEndTime());
            Timestamp createTime = jobExecution.getCreateTime() == null ? null : Timestamp.valueOf(jobExecution.getCreateTime());
            Timestamp lastUpdated = jobExecution.getLastUpdated() == null ? null : Timestamp.valueOf(jobExecution.getLastUpdated());
            Object[] parameters = new Object[]{startTime, endTime, jobExecution.getStatus().toString(), jobExecution.getExitStatus().getExitCode(), exitDescription, version, createTime, lastUpdated, jobExecution.getId(), jobExecution.getVersion()};
            if ((Integer)this.getJdbcTemplate().queryForObject(this.getQuery(CHECK_JOB_EXECUTION_EXISTS), Integer.class, new Object[]{jobExecution.getId()}) != 1) {
                throw new NoSuchObjectException("Invalid JobExecution, ID " + jobExecution.getId() + " not found.");
            }
            int count = this.getJdbcTemplate().update(this.getQuery(UPDATE_JOB_EXECUTION), parameters, new int[]{93, 93, 12, 12, 12, 4, 93, 93, -5, 4});
            if (count == 0) {
                int currentVersion = (Integer)this.getJdbcTemplate().queryForObject(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), Integer.class, new Object[]{jobExecution.getId()});
                throw new OptimisticLockingFailureException("Attempt to update job execution id=" + jobExecution.getId() + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + currentVersion);
            }
            jobExecution.incrementVersion();
        }
    }

    @Override
    @Nullable
    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        Long id = jobInstance.getId();
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_LAST_EXECUTION), (RowMapper)new JobExecutionRowMapper(jobInstance), new Object[]{id, id});
        Assert.state((executions.size() <= 1 ? 1 : 0) != 0, (String)"There must be at most one latest job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return (JobExecution)executions.get(0);
    }

    @Override
    @Nullable
    public JobExecution getJobExecution(Long executionId) {
        try {
            JobExecution jobExecution = (JobExecution)this.getJdbcTemplate().queryForObject(this.getQuery(GET_EXECUTION_BY_ID), (RowMapper)new JobExecutionRowMapper(), new Object[]{executionId});
            return jobExecution;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        final HashSet<JobExecution> result = new HashSet<JobExecution>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobExecutionRowMapper mapper = new JobExecutionRowMapper();
                result.add(mapper.mapRow(rs, 0));
            }
        };
        this.getJdbcTemplate().query(this.getQuery(GET_RUNNING_EXECUTIONS), handler, new Object[]{jobName});
        return result;
    }

    @Override
    public void synchronizeStatus(JobExecution jobExecution) {
        int currentVersion = (Integer)this.getJdbcTemplate().queryForObject(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), Integer.class, new Object[]{jobExecution.getId()});
        if (currentVersion != jobExecution.getVersion()) {
            String status = (String)this.getJdbcTemplate().queryForObject(this.getQuery(GET_STATUS), String.class, new Object[]{jobExecution.getId()});
            jobExecution.upgradeStatus(BatchStatus.valueOf(status));
            jobExecution.setVersion(currentVersion);
        }
    }

    @Override
    public void deleteJobExecution(JobExecution jobExecution) {
        this.getJdbcTemplate().update(this.getQuery(DELETE_JOB_EXECUTION), new Object[]{jobExecution.getId()});
    }

    @Override
    public void deleteJobExecutionParameters(JobExecution jobExecution) {
        this.getJdbcTemplate().update(this.getQuery(DELETE_JOB_EXECUTION_PARAMETERS), new Object[]{jobExecution.getId()});
    }

    private void insertJobParameters(Long executionId, JobParameters jobParameters) {
        for (Map.Entry<String, JobParameter<?>> entry : jobParameters.getParameters().entrySet()) {
            JobParameter<?> jobParameter = entry.getValue();
            this.insertParameter(executionId, jobParameter.getType(), entry.getKey(), jobParameter.getValue(), jobParameter.isIdentifying());
        }
    }

    private <T> void insertParameter(Long executionId, Class<T> type, String key, T value, boolean identifying) {
        Object[] args = new Object[]{};
        int[] argTypes = new int[]{-5, 12, 12, 12, 1};
        String identifyingFlag = identifying ? "Y" : "N";
        String stringValue = (String)this.conversionService.convert(value, String.class);
        args = new Object[]{executionId, key, type.getName(), stringValue, identifyingFlag};
        this.getJdbcTemplate().update(this.getQuery(CREATE_JOB_PARAMETERS), args, argTypes);
    }

    protected JobParameters getJobParameters(Long executionId) {
        final HashMap map = new HashMap();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String parameterName = rs.getString("PARAMETER_NAME");
                Class<?> parameterType = null;
                try {
                    parameterType = Class.forName(rs.getString("PARAMETER_TYPE"));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                String stringValue = rs.getString("PARAMETER_VALUE");
                Object typedValue = JdbcJobExecutionDao.this.conversionService.convert((Object)stringValue, parameterType);
                boolean identifying = rs.getString("IDENTIFYING").equalsIgnoreCase("Y");
                JobParameter<Object> jobParameter = new JobParameter<Object>(typedValue, parameterType, identifying);
                map.put(parameterName, jobParameter);
            }
        };
        this.getJdbcTemplate().query(this.getQuery(FIND_PARAMS_FROM_ID), handler, new Object[]{executionId});
        return new JobParameters(map);
    }

    private final class JobExecutionRowMapper
    implements RowMapper<JobExecution> {
        private JobInstance jobInstance;
        private JobParameters jobParameters;

        public JobExecutionRowMapper() {
        }

        public JobExecutionRowMapper(JobInstance jobInstance) {
            this.jobInstance = jobInstance;
        }

        public JobExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = rs.getLong(1);
            if (this.jobParameters == null) {
                this.jobParameters = JdbcJobExecutionDao.this.getJobParameters(id);
            }
            JobExecution jobExecution = this.jobInstance == null ? new JobExecution(id, this.jobParameters) : new JobExecution(this.jobInstance, id, this.jobParameters);
            jobExecution.setStartTime(rs.getTimestamp(2) == null ? null : rs.getTimestamp(2).toLocalDateTime());
            jobExecution.setEndTime(rs.getTimestamp(3) == null ? null : rs.getTimestamp(3).toLocalDateTime());
            jobExecution.setStatus(BatchStatus.valueOf(rs.getString(4)));
            jobExecution.setExitStatus(new ExitStatus(rs.getString(5), rs.getString(6)));
            jobExecution.setCreateTime(rs.getTimestamp(7) == null ? null : rs.getTimestamp(7).toLocalDateTime());
            jobExecution.setLastUpdated(rs.getTimestamp(8) == null ? null : rs.getTimestamp(8).toLocalDateTime());
            jobExecution.setVersion(rs.getInt(9));
            return jobExecution;
        }
    }
}

