/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import java.util.Properties;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.SimpleJobRepository;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class AbstractJobRepositoryFactoryBean
implements FactoryBean<JobRepository>,
InitializingBean {
    private PlatformTransactionManager transactionManager;
    private TransactionAttributeSource transactionAttributeSource;
    private ProxyFactory proxyFactory = new ProxyFactory();
    private String isolationLevelForCreate = "ISOLATION_SERIALIZABLE";
    private boolean validateTransactionState = true;
    private static final String TRANSACTION_ISOLATION_LEVEL_PREFIX = "ISOLATION_";
    private static final String TRANSACTION_PROPAGATION_PREFIX = "PROPAGATION_";
    private static final String DEFAULT_ISOLATION_LEVEL = "ISOLATION_SERIALIZABLE";

    protected abstract JobInstanceDao createJobInstanceDao() throws Exception;

    protected abstract JobExecutionDao createJobExecutionDao() throws Exception;

    protected abstract StepExecutionDao createStepExecutionDao() throws Exception;

    protected abstract ExecutionContextDao createExecutionContextDao() throws Exception;

    public Class<JobRepository> getObjectType() {
        return JobRepository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setValidateTransactionState(boolean validateTransactionState) {
        this.validateTransactionState = validateTransactionState;
    }

    public void setIsolationLevelForCreate(String isolationLevelForCreate) {
        this.isolationLevelForCreate = isolationLevelForCreate;
    }

    public void setIsolationLevelForCreateEnum(Isolation isolationLevelForCreate) {
        this.setIsolationLevelForCreate(TRANSACTION_ISOLATION_LEVEL_PREFIX + isolationLevelForCreate.name());
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        Assert.notNull((Object)transactionAttributeSource, (String)"transactionAttributeSource must not be null.");
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"TransactionManager must not be null.");
        if (this.transactionAttributeSource == null) {
            Properties transactionAttributes = new Properties();
            transactionAttributes.setProperty("create*", TRANSACTION_PROPAGATION_PREFIX + Propagation.REQUIRES_NEW + "," + this.isolationLevelForCreate);
            transactionAttributes.setProperty("getLastJobExecution*", TRANSACTION_PROPAGATION_PREFIX + Propagation.REQUIRES_NEW + "," + this.isolationLevelForCreate);
            transactionAttributes.setProperty("*", "PROPAGATION_REQUIRED");
            this.transactionAttributeSource = new NameMatchTransactionAttributeSource();
            ((NameMatchTransactionAttributeSource)this.transactionAttributeSource).setProperties(transactionAttributes);
        }
    }

    public JobRepository getObject() throws Exception {
        TransactionInterceptor advice = new TransactionInterceptor((TransactionManager)this.transactionManager, this.transactionAttributeSource);
        if (this.validateTransactionState) {
            DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Advice)new MethodInterceptor(){

                public Object invoke(MethodInvocation invocation) throws Throwable {
                    if (TransactionSynchronizationManager.isActualTransactionActive()) {
                        throw new IllegalStateException("Existing transaction detected in JobRepository. Please fix this and try again (e.g. remove @Transactional annotations from client).");
                    }
                    return invocation.proceed();
                }
            });
            NameMatchMethodPointcut pointcut = new NameMatchMethodPointcut();
            pointcut.addMethodName("create*");
            advisor.setPointcut((Pointcut)pointcut);
            this.proxyFactory.addAdvisor((Advisor)advisor);
        }
        this.proxyFactory.addAdvice((Advice)advice);
        this.proxyFactory.setProxyTargetClass(false);
        this.proxyFactory.addInterface(JobRepository.class);
        this.proxyFactory.setTarget(this.getTarget());
        return (JobRepository)this.proxyFactory.getProxy(this.getClass().getClassLoader());
    }

    private Object getTarget() throws Exception {
        return new SimpleJobRepository(this.createJobInstanceDao(), this.createJobExecutionDao(), this.createStepExecutionDao(), this.createExecutionContextDao());
    }
}

