/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Types;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.dao.DefaultExecutionContextSerializer;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JdbcExecutionContextDao;
import org.springframework.batch.core.repository.dao.JdbcJobExecutionDao;
import org.springframework.batch.core.repository.dao.JdbcJobInstanceDao;
import org.springframework.batch.core.repository.dao.JdbcStepExecutionDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.AbstractJobRepositoryFactoryBean;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JobRepositoryFactoryBean
extends AbstractJobRepositoryFactoryBean
implements InitializingBean {
    protected static final Log logger = LogFactory.getLog(JobRepositoryFactoryBean.class);
    private DataSource dataSource;
    private JdbcOperations jdbcOperations;
    private String databaseType;
    private String tablePrefix = "BATCH_";
    private DataFieldMaxValueIncrementerFactory incrementerFactory;
    private int maxVarCharLength = 2500;
    private LobHandler lobHandler;
    private ExecutionContextSerializer serializer;
    private Integer clobType;
    private Charset charset = StandardCharsets.UTF_8;
    private ConfigurableConversionService conversionService;

    public void setClobType(int type) {
        this.clobType = type;
    }

    public void setSerializer(ExecutionContextSerializer serializer) {
        this.serializer = serializer;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setMaxVarCharLength(int maxVarCharLength) {
        this.maxVarCharLength = maxVarCharLength;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public void setDatabaseType(String dbType) {
        this.databaseType = dbType;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setIncrementerFactory(DataFieldMaxValueIncrementerFactory incrementerFactory) {
        this.incrementerFactory = incrementerFactory;
    }

    public void setCharset(@NonNull Charset charset) {
        Assert.notNull((Object)charset, (String)"Charset must not be null");
        this.charset = charset;
    }

    public void setConversionService(@NonNull ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource must not be null.");
        if (this.jdbcOperations == null) {
            this.jdbcOperations = new JdbcTemplate(this.dataSource);
        }
        if (this.incrementerFactory == null) {
            this.incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(this.dataSource);
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseType.fromMetaData((DataSource)this.dataSource).name();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("No database type set, using meta data indicating: " + this.databaseType));
            }
        }
        if (this.lobHandler == null && this.databaseType.equalsIgnoreCase(DatabaseType.ORACLE.toString())) {
            this.lobHandler = new DefaultLobHandler();
        }
        if (this.serializer == null) {
            DefaultExecutionContextSerializer defaultSerializer = new DefaultExecutionContextSerializer();
            this.serializer = defaultSerializer;
        }
        Assert.state((boolean)this.incrementerFactory.isSupportedIncrementerType(this.databaseType), () -> "'" + this.databaseType + "' is an unsupported database type.  The supported database types are " + StringUtils.arrayToCommaDelimitedString((Object[])this.incrementerFactory.getSupportedIncrementerTypes()));
        if (this.clobType != null) {
            Assert.state((boolean)this.isValidTypes(this.clobType), (String)"lobType must be a value from the java.sql.Types class");
        }
        if (this.conversionService == null) {
            this.conversionService = new DefaultConversionService();
        }
        super.afterPropertiesSet();
    }

    @Override
    protected JobInstanceDao createJobInstanceDao() throws Exception {
        JdbcJobInstanceDao dao = new JdbcJobInstanceDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setJobInstanceIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }

    @Override
    protected JobExecutionDao createJobExecutionDao() throws Exception {
        JdbcJobExecutionDao dao = new JdbcJobExecutionDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setJobExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        dao.setExitMessageLength(this.maxVarCharLength);
        dao.setConversionService(this.conversionService);
        dao.afterPropertiesSet();
        return dao;
    }

    @Override
    protected StepExecutionDao createStepExecutionDao() throws Exception {
        JdbcStepExecutionDao dao = new JdbcStepExecutionDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setStepExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "STEP_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        dao.setExitMessageLength(this.maxVarCharLength);
        dao.afterPropertiesSet();
        return dao;
    }

    @Override
    protected ExecutionContextDao createExecutionContextDao() throws Exception {
        JdbcExecutionContextDao dao = new JdbcExecutionContextDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        dao.setSerializer(this.serializer);
        dao.setCharset(this.charset);
        if (this.lobHandler != null) {
            dao.setLobHandler(this.lobHandler);
        }
        dao.afterPropertiesSet();
        dao.setShortContextLength(this.maxVarCharLength);
        return dao;
    }

    private int determineClobTypeToUse(String databaseType) throws Exception {
        if (this.clobType != null) {
            return this.clobType;
        }
        if (DatabaseType.SYBASE == DatabaseType.valueOf((String)databaseType.toUpperCase())) {
            return -1;
        }
        return 2005;
    }

    private boolean isValidTypes(int value) throws Exception {
        boolean result = false;
        for (Field field : Types.class.getFields()) {
            int curValue = field.getInt(null);
            if (curValue != value) continue;
            result = true;
            break;
        }
        return result;
    }
}

