/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.SerializationUtils;

public class DefaultExecutionContextSerializer
implements ExecutionContextSerializer {
    public void serialize(Map<String, Object> context, OutputStream out) throws IOException {
        Assert.notNull(context, (String)"context is required");
        Assert.notNull((Object)out, (String)"OutputStream is required");
        for (Object value : context.values()) {
            Assert.notNull((Object)value, (String)"A null value was found");
            if (value instanceof Serializable) continue;
            throw new IllegalArgumentException("Value: [" + value + "] must be serializable. Object of class: [" + value.getClass().getName() + "] must be an instance of " + Serializable.class);
        }
        byte[] serializedContext = SerializationUtils.serialize(context);
        String base64EncodedContext = Base64Utils.encodeToString((byte[])serializedContext);
        out.write(base64EncodedContext.getBytes());
    }

    public Map<String, Object> deserialize(InputStream inputStream) throws IOException {
        String base64EncodedContext = new String(inputStream.readAllBytes());
        byte[] decodedContext = Base64Utils.decodeFromString((String)base64EncodedContext);
        return (Map)SerializationUtils.deserialize((byte[])decodedContext);
    }
}

