/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.builder;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.annotation.AfterChunk;
import org.springframework.batch.core.annotation.AfterChunkError;
import org.springframework.batch.core.annotation.BeforeChunk;
import org.springframework.batch.core.listener.StepListenerFactoryBean;
import org.springframework.batch.core.step.builder.StepBuilderException;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;
import org.springframework.batch.support.ReflectionUtils;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;

public abstract class AbstractTaskletStepBuilder<B extends AbstractTaskletStepBuilder<B>>
extends StepBuilderHelper<B> {
    protected Set<ChunkListener> chunkListeners = new LinkedHashSet<ChunkListener>();
    private RepeatOperations stepOperations;
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute;
    private Set<ItemStream> streams = new LinkedHashSet<ItemStream>();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private int throttleLimit = 4;
    private TaskExecutor taskExecutor;

    public AbstractTaskletStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    protected abstract Tasklet createTasklet();

    public TaskletStep build() {
        this.registerStepListenerAsChunkListener();
        TaskletStep step = new TaskletStep(this.getName());
        super.enhance(step);
        step.setChunkListeners(this.chunkListeners.toArray(new ChunkListener[0]));
        if (this.transactionManager != null) {
            step.setTransactionManager(this.transactionManager);
        }
        if (this.transactionAttribute != null) {
            step.setTransactionAttribute(this.transactionAttribute);
        }
        if (this.stepOperations == null) {
            this.stepOperations = new RepeatTemplate();
            if (this.taskExecutor != null) {
                TaskExecutorRepeatTemplate repeatTemplate = new TaskExecutorRepeatTemplate();
                repeatTemplate.setTaskExecutor(this.taskExecutor);
                repeatTemplate.setThrottleLimit(this.throttleLimit);
                this.stepOperations = repeatTemplate;
            }
            ((RepeatTemplate)this.stepOperations).setExceptionHandler(this.exceptionHandler);
        }
        step.setStepOperations(this.stepOperations);
        step.setTasklet(this.createTasklet());
        step.setStreams(this.streams.toArray(new ItemStream[0]));
        try {
            step.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return step;
    }

    protected void registerStepListenerAsChunkListener() {
        for (StepExecutionListener stepExecutionListener : this.properties.getStepExecutionListeners()) {
            if (!(stepExecutionListener instanceof ChunkListener)) continue;
            this.listener((ChunkListener)((Object)stepExecutionListener));
        }
    }

    public B listener(ChunkListener listener) {
        this.chunkListeners.add(listener);
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    @Override
    public B listener(Object listener) {
        super.listener(listener);
        HashSet chunkListenerMethods = new HashSet();
        chunkListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), BeforeChunk.class));
        chunkListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), AfterChunk.class));
        chunkListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), AfterChunkError.class));
        if (chunkListenerMethods.size() > 0) {
            StepListenerFactoryBean factory = new StepListenerFactoryBean();
            factory.setDelegate(listener);
            this.listener((ChunkListener)factory.getObject());
        }
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    public B stream(ItemStream stream) {
        this.streams.add(stream);
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    public B taskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    @Deprecated(since="5.0", forRemoval=true)
    public B throttleLimit(int throttleLimit) {
        this.throttleLimit = throttleLimit;
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    public B exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    public B stepOperations(RepeatOperations repeatTemplate) {
        this.stepOperations = repeatTemplate;
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    public B transactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    public B transactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
        return (B)((AbstractTaskletStepBuilder)this.self());
    }

    protected RepeatOperations getStepOperations() {
        return this.stepOperations;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected boolean concurrent() {
        boolean concurrent = this.taskExecutor != null && !(this.taskExecutor instanceof SyncTaskExecutor);
        return concurrent;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Deprecated(since="5.0", forRemoval=true)
    protected int getThrottleLimit() {
        return this.throttleLimit;
    }

    protected TransactionAttribute getTransactionAttribute() {
        return this.transactionAttribute;
    }

    protected Set<ItemStream> getStreams() {
        return this.streams;
    }

    protected PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

