/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JobParameters
implements Serializable {
    private final Map<String, JobParameter<?>> parameters;

    public JobParameters() {
        this.parameters = new HashMap();
    }

    public JobParameters(Map<String, JobParameter<?>> parameters) {
        this.parameters = new HashMap(parameters);
    }

    @Nullable
    public Long getLong(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        JobParameter<?> jobParameter = this.parameters.get(key);
        if (!jobParameter.getType().equals(Long.class)) {
            throw new IllegalArgumentException("Key " + key + " is not of type Long");
        }
        return (Long)jobParameter.getValue();
    }

    @Nullable
    public Long getLong(String key, @Nullable Long defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLong(key);
        }
        return defaultValue;
    }

    @Nullable
    public String getString(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        JobParameter<?> jobParameter = this.parameters.get(key);
        if (!jobParameter.getType().equals(String.class)) {
            throw new IllegalArgumentException("Key " + key + " is not of type String");
        }
        return (String)jobParameter.getValue();
    }

    @Nullable
    public String getString(String key, @Nullable String defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }

    @Nullable
    public Double getDouble(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        JobParameter<?> jobParameter = this.parameters.get(key);
        if (!jobParameter.getType().equals(Double.class)) {
            throw new IllegalArgumentException("Key " + key + " is not of type Double");
        }
        return (Double)jobParameter.getValue();
    }

    @Nullable
    public Double getDouble(String key, @Nullable Double defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getDouble(key);
        }
        return defaultValue;
    }

    @Nullable
    public Date getDate(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        JobParameter<?> jobParameter = this.parameters.get(key);
        if (!jobParameter.getType().equals(Date.class)) {
            throw new IllegalArgumentException("Key " + key + " is not of type java.util.Date");
        }
        return (Date)jobParameter.getValue();
    }

    @Nullable
    public Date getDate(String key, @Nullable Date defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getDate(key);
        }
        return defaultValue;
    }

    @Nullable
    public LocalDate getLocalDate(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        JobParameter<?> jobParameter = this.parameters.get(key);
        if (!jobParameter.getType().equals(LocalDate.class)) {
            throw new IllegalArgumentException("Key " + key + " is not of type java.time.LocalDate");
        }
        return (LocalDate)jobParameter.getValue();
    }

    @Nullable
    public LocalDate getLocalDate(String key, @Nullable LocalDate defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLocalDate(key);
        }
        return defaultValue;
    }

    @Nullable
    public LocalTime getLocalTime(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        JobParameter<?> jobParameter = this.parameters.get(key);
        if (!jobParameter.getType().equals(LocalTime.class)) {
            throw new IllegalArgumentException("Key " + key + " is not of type java.time.LocalTime");
        }
        return (LocalTime)jobParameter.getValue();
    }

    @Nullable
    public LocalTime getLocalTime(String key, @Nullable LocalTime defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLocalTime(key);
        }
        return defaultValue;
    }

    @Nullable
    public LocalDateTime getLocalDateTime(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        JobParameter<?> jobParameter = this.parameters.get(key);
        if (!jobParameter.getType().equals(LocalDateTime.class)) {
            throw new IllegalArgumentException("Key " + key + " is not of type java.time.LocalDateTime");
        }
        return (LocalDateTime)jobParameter.getValue();
    }

    @Nullable
    public LocalDateTime getLocalDateTime(String key, @Nullable LocalDateTime defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLocalDateTime(key);
        }
        return defaultValue;
    }

    @Nullable
    public JobParameter<?> getParameter(String key) {
        Assert.notNull((Object)key, (String)"key must not be null");
        return this.parameters.get(key);
    }

    public Map<String, JobParameter<?>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        JobParameters rhs = (JobParameters)obj;
        return this.parameters.equals(rhs.parameters);
    }

    public int hashCode() {
        return 17 + 23 * this.parameters.hashCode();
    }

    public String toString() {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Map.Entry<String, JobParameter<?>> entry : this.parameters.entrySet()) {
            parameters.add(String.format("'%s':'%s'", entry.getKey(), entry.getValue()));
        }
        return "{" + String.join((CharSequence)",", parameters) + "}";
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Properties toProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, JobParameter<?>> param : this.parameters.entrySet()) {
            if (param.getValue() == null) continue;
            props.put(param.getKey(), Objects.toString(param.getValue().toString(), ""));
        }
        return props;
    }
}

