/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;

public class StepContribution
implements Serializable {
    private volatile long readCount = 0L;
    private volatile long writeCount = 0L;
    private volatile long filterCount = 0L;
    private final long parentSkipCount;
    private volatile long readSkipCount;
    private volatile long writeSkipCount;
    private volatile long processSkipCount;
    private ExitStatus exitStatus = ExitStatus.EXECUTING;
    private volatile StepExecution stepExecution;

    public StepContribution(StepExecution execution) {
        this.stepExecution = execution;
        this.parentSkipCount = execution.getSkipCount();
    }

    public void setExitStatus(ExitStatus status) {
        this.exitStatus = status;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void incrementFilterCount(long count) {
        this.filterCount += count;
    }

    public void incrementReadCount() {
        ++this.readCount;
    }

    public void incrementWriteCount(long count) {
        this.writeCount += count;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public long getFilterCount() {
        return this.filterCount;
    }

    public long getStepSkipCount() {
        return this.readSkipCount + this.writeSkipCount + this.processSkipCount + this.parentSkipCount;
    }

    public long getSkipCount() {
        return this.readSkipCount + this.writeSkipCount + this.processSkipCount;
    }

    public void incrementReadSkipCount() {
        ++this.readSkipCount;
    }

    public void incrementReadSkipCount(long count) {
        this.readSkipCount += count;
    }

    public void incrementWriteSkipCount() {
        ++this.writeSkipCount;
    }

    public void incrementProcessSkipCount() {
        ++this.processSkipCount;
    }

    public long getReadSkipCount() {
        return this.readSkipCount;
    }

    public long getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public long getProcessSkipCount() {
        return this.processSkipCount;
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }

    public String toString() {
        return "[StepContribution: read=" + this.readCount + ", written=" + this.writeCount + ", filtered=" + this.filterCount + ", readSkips=" + this.readSkipCount + ", writeSkips=" + this.writeSkipCount + ", processSkips=" + this.processSkipCount + ", exitStatus=" + this.exitStatus.getExitCode() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StepContribution)) {
            return false;
        }
        StepContribution other = (StepContribution)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return 11 + this.toString().hashCode() * 43;
    }
}

