/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.FlowStepBuilder;
import org.springframework.batch.core.step.builder.JobStepBuilder;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.job.JobParametersExtractor;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.policy.MapRetryContextCache;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class StepParserStepFactoryBean<I, O>
implements FactoryBean<Step>,
BeanNameAware {
    private String name;
    private Boolean allowStartIfComplete;
    private JobRepository jobRepository;
    private Integer startLimit;
    private Tasklet tasklet;
    private PlatformTransactionManager transactionManager;
    private Set<Object> stepExecutionListeners = new LinkedHashSet<Object>();
    private Flow flow;
    private Job job;
    private JobLauncher jobLauncher;
    private JobParametersExtractor jobParametersExtractor;
    private Partitioner partitioner;
    private static final int DEFAULT_GRID_SIZE = 6;
    private Step step;
    private PartitionHandler partitionHandler;
    private int gridSize = 6;
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses;
    private Integer transactionTimeout;
    private Propagation propagation;
    private Isolation isolation;
    private Set<ChunkListener> chunkListeners = new LinkedHashSet<ChunkListener>();
    private int cacheCapacity = 0;
    private CompletionPolicy chunkCompletionPolicy;
    private Integer commitInterval;
    private Boolean readerTransactionalQueue;
    private Boolean processorTransactional;
    private int retryLimit = 0;
    private BackOffPolicy backOffPolicy;
    private RetryPolicy retryPolicy;
    private RetryContextCache retryContextCache;
    private KeyGenerator keyGenerator;
    private Integer skipLimit;
    private SkipPolicy skipPolicy;
    private TaskExecutor taskExecutor;
    private Integer throttleLimit;
    private ItemReader<? extends I> itemReader;
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private RetryListener[] retryListeners;
    private Map<Class<? extends Throwable>, Boolean> skippableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private ItemStream[] streams;
    private Set<ItemReadListener<I>> readListeners = new LinkedHashSet<ItemReadListener<I>>();
    private Set<ItemWriteListener<O>> writeListeners = new LinkedHashSet<ItemWriteListener<O>>();
    private Set<ItemProcessListener<I, O>> processListeners = new LinkedHashSet<ItemProcessListener<I, O>>();
    private Set<SkipListener<I, O>> skipListeners = new LinkedHashSet<SkipListener<I, O>>();
    private boolean hasChunkElement = false;
    private StepExecutionAggregator stepExecutionAggregator;

    public Step getObject() throws Exception {
        if (this.hasChunkElement) {
            Assert.isNull((Object)this.tasklet, (String)("Step [" + this.name + "] has both a <chunk/> element and a 'ref' attribute  referencing a Tasklet."));
            this.validateFaultTolerantSettings();
            if (this.isFaultTolerant()) {
                return this.createFaultTolerantStep();
            }
            return this.createSimpleStep();
        }
        if (this.tasklet != null) {
            return this.createTaskletStep();
        }
        if (this.flow != null) {
            return this.createFlowStep();
        }
        if (this.job != null) {
            return this.createJobStep();
        }
        return this.createPartitionStep();
    }

    public boolean requiresTransactionManager() {
        return this.hasChunkElement || this.tasklet != null;
    }

    protected void enhanceCommonStep(StepBuilderHelper<?> builder) {
        if (this.allowStartIfComplete != null) {
            builder.allowStartIfComplete(this.allowStartIfComplete);
        }
        if (this.startLimit != null) {
            builder.startLimit(this.startLimit);
        }
        for (Object listener : this.stepExecutionListeners) {
            if (!(listener instanceof StepExecutionListener)) continue;
            builder.listener((StepExecutionListener)listener);
        }
    }

    protected Step createPartitionStep() {
        PartitionStepBuilder builder = this.partitioner != null ? new StepBuilder(this.name, this.jobRepository).partitioner(this.step != null ? this.step.getName() : this.name, this.partitioner).step(this.step) : new StepBuilder(this.name, this.jobRepository).partitioner(this.step);
        this.enhanceCommonStep(builder);
        if (this.partitionHandler != null) {
            builder.partitionHandler(this.partitionHandler);
        } else {
            builder.gridSize(this.gridSize);
            builder.taskExecutor(this.taskExecutor);
        }
        builder.aggregator(this.stepExecutionAggregator);
        return builder.build();
    }

    protected Step createFaultTolerantStep() {
        FaultTolerantStepBuilder<Object, Object> builder = this.getFaultTolerantStepBuilder(this.name);
        if (this.commitInterval != null) {
            builder.chunk(this.commitInterval);
        }
        builder.chunk(this.chunkCompletionPolicy);
        this.enhanceTaskletStepBuilder(builder);
        builder.reader(this.itemReader);
        builder.writer(this.itemWriter);
        builder.processor(this.itemProcessor);
        if (this.processorTransactional != null && !this.processorTransactional.booleanValue()) {
            builder.processorNonTransactional();
        }
        if (this.readerTransactionalQueue != null && this.readerTransactionalQueue.booleanValue()) {
            builder.readerIsTransactionalQueue();
        }
        for (SkipListener<I, O> skipListener : this.skipListeners) {
            builder.listener(skipListener);
        }
        this.registerItemListeners(builder);
        if (this.skipPolicy != null) {
            builder.skipPolicy(this.skipPolicy);
        } else if (this.skipLimit != null) {
            builder.skipLimit(this.skipLimit);
            for (Class clazz : this.skippableExceptionClasses.keySet()) {
                if (this.skippableExceptionClasses.get(clazz).booleanValue()) {
                    builder.skip(clazz);
                    continue;
                }
                builder.noSkip(clazz);
            }
        }
        if (this.retryListeners != null) {
            for (RetryListener listener : this.retryListeners) {
                builder.listener(listener);
            }
        }
        if (this.retryContextCache == null && this.cacheCapacity > 0) {
            this.retryContextCache = new MapRetryContextCache(this.cacheCapacity);
        }
        builder.retryContextCache(this.retryContextCache);
        builder.keyGenerator(this.keyGenerator);
        if (this.retryPolicy != null) {
            builder.retryPolicy(this.retryPolicy);
        } else {
            builder.retryLimit(this.retryLimit);
            builder.backOffPolicy(this.backOffPolicy);
            for (Class clazz : this.retryableExceptionClasses.keySet()) {
                if (this.retryableExceptionClasses.get(clazz).booleanValue()) {
                    builder.retry(clazz);
                    continue;
                }
                builder.noRetry(clazz);
            }
        }
        if (this.noRollbackExceptionClasses != null) {
            for (Class clazz : this.noRollbackExceptionClasses) {
                builder.noRollback(clazz);
            }
        }
        return builder.build();
    }

    protected FaultTolerantStepBuilder<I, O> getFaultTolerantStepBuilder(String stepName) {
        return new FaultTolerantStepBuilder(new StepBuilder(stepName, this.jobRepository));
    }

    protected void registerItemListeners(SimpleStepBuilder<I, O> builder) {
        for (ItemReadListener<I> itemReadListener : this.readListeners) {
            builder.listener(itemReadListener);
        }
        for (ItemWriteListener itemWriteListener : this.writeListeners) {
            builder.listener(itemWriteListener);
        }
        for (ItemProcessListener itemProcessListener : this.processListeners) {
            builder.listener(itemProcessListener);
        }
    }

    protected Step createSimpleStep() {
        SimpleStepBuilder<Object, Object> builder = this.getSimpleStepBuilder(this.name);
        this.setChunk(builder);
        this.enhanceTaskletStepBuilder(builder);
        this.registerItemListeners(builder);
        builder.reader(this.itemReader);
        builder.writer(this.itemWriter);
        builder.processor(this.itemProcessor);
        return builder.build();
    }

    protected void setChunk(SimpleStepBuilder<I, O> builder) {
        if (this.commitInterval != null) {
            builder.chunk(this.commitInterval);
        }
        builder.chunk(this.chunkCompletionPolicy);
    }

    protected CompletionPolicy getCompletionPolicy() {
        return this.chunkCompletionPolicy;
    }

    protected SimpleStepBuilder<I, O> getSimpleStepBuilder(String stepName) {
        return new SimpleStepBuilder(new StepBuilder(stepName, this.jobRepository));
    }

    protected TaskletStep createTaskletStep() {
        TaskletStepBuilder builder = new TaskletStepBuilder(new StepBuilder(this.name, this.jobRepository)).tasklet(this.tasklet, this.transactionManager);
        this.enhanceTaskletStepBuilder(builder);
        return builder.build();
    }

    protected void enhanceTaskletStepBuilder(AbstractTaskletStepBuilder<?> builder) {
        this.enhanceCommonStep(builder);
        for (ChunkListener listener : this.chunkListeners) {
            builder.listener(listener);
        }
        builder.taskExecutor(this.taskExecutor);
        if (this.throttleLimit != null) {
            builder.throttleLimit(this.throttleLimit);
        }
        builder.transactionManager(this.transactionManager);
        if (this.transactionTimeout != null || this.propagation != null || this.isolation != null || this.noRollbackExceptionClasses != null) {
            DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
            if (this.propagation != null) {
                attribute.setPropagationBehavior(this.propagation.value());
            }
            if (this.isolation != null) {
                attribute.setIsolationLevel(this.isolation.value());
            }
            if (this.transactionTimeout != null) {
                attribute.setTimeout(this.transactionTimeout.intValue());
            }
            Collection<Object> exceptions = this.noRollbackExceptionClasses == null ? new HashSet() : this.noRollbackExceptionClasses;
            final BinaryExceptionClassifier classifier = new BinaryExceptionClassifier(exceptions, false);
            builder.transactionAttribute((TransactionAttribute)new DefaultTransactionAttribute((TransactionAttribute)attribute){

                public boolean rollbackOn(Throwable ex) {
                    return classifier.classify(ex);
                }
            });
        }
        if (this.streams != null) {
            for (ItemStream stream : this.streams) {
                builder.stream(stream);
            }
        }
    }

    protected Step createFlowStep() {
        FlowStepBuilder builder = new StepBuilder(this.name, this.jobRepository).flow(this.flow);
        this.enhanceCommonStep(builder);
        return builder.build();
    }

    private Step createJobStep() throws Exception {
        JobStepBuilder builder = new StepBuilder(this.name, this.jobRepository).job(this.job);
        this.enhanceCommonStep(builder);
        builder.parametersExtractor(this.jobParametersExtractor);
        builder.launcher(this.jobLauncher);
        return builder.build();
    }

    protected void validateFaultTolerantSettings() {
        this.validateDependency("skippable-exception-classes", this.skippableExceptionClasses, "skip-limit", this.skipLimit, true);
        this.validateDependency("retryable-exception-classes", this.retryableExceptionClasses, "retry-limit", this.retryLimit, true);
        this.validateDependency("retry-listeners", this.retryListeners, "retry-limit", this.retryLimit, false);
        if (this.isPresent(this.processorTransactional) && !this.processorTransactional.booleanValue() && this.isPresent(this.readerTransactionalQueue) && this.readerTransactionalQueue.booleanValue()) {
            throw new IllegalArgumentException("The field 'processor-transactional' cannot be false if 'reader-transactional-queue' is true");
        }
    }

    private void validateDependency(String dependentName, Object dependentValue, String name, Object value, boolean twoWayDependency) {
        if (this.isPresent(dependentValue) && !this.isPresent(value)) {
            throw new IllegalArgumentException("The field '" + dependentName + "' is not permitted on the step [" + this.name + "] because there is no '" + name + "'.");
        }
        if (twoWayDependency && this.isPresent(value) && !this.isPresent(dependentValue)) {
            throw new IllegalArgumentException("The field '" + name + "' is not permitted on the step [" + this.name + "] because there is no '" + dependentName + "'.");
        }
    }

    private boolean isPresent(Object o) {
        if (o instanceof Integer) {
            return this.isPositive((Integer)o);
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        return o != null;
    }

    protected boolean isFaultTolerant() {
        return this.backOffPolicy != null || this.skipPolicy != null || this.retryPolicy != null || this.isPositive(this.skipLimit) || this.isPositive(this.retryLimit) || this.isPositive(this.cacheCapacity) || this.isTrue(this.readerTransactionalQueue);
    }

    private boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    private boolean isPositive(Integer n) {
        return n != null && n > 0;
    }

    public Class<TaskletStep> getObjectType() {
        return TaskletStep.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setJobParametersExtractor(JobParametersExtractor jobParametersExtractor) {
        this.jobParametersExtractor = jobParametersExtractor;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void setStepExecutionAggregator(StepExecutionAggregator stepExecutionAggregator) {
        this.stepExecutionAggregator = stepExecutionAggregator;
    }

    protected StepExecutionAggregator getStepExecutionAggergator() {
        return this.stepExecutionAggregator;
    }

    public void setPartitionHandler(PartitionHandler partitionHandler) {
        this.partitionHandler = partitionHandler;
    }

    protected PartitionHandler getPartitionHandler() {
        return this.partitionHandler;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    protected Tasklet getTasklet() {
        return this.tasklet;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setListeners(Object[] listeners) {
        for (Object listener : listeners) {
            if (listener instanceof SkipListener) {
                SkipListener skipListener = (SkipListener)listener;
                this.skipListeners.add(skipListener);
            }
            if (listener instanceof StepExecutionListener) {
                StepExecutionListener stepExecutionListener = (StepExecutionListener)listener;
                this.stepExecutionListeners.add(stepExecutionListener);
            }
            if (listener instanceof ChunkListener) {
                ChunkListener chunkListener = (ChunkListener)listener;
                this.chunkListeners.add(chunkListener);
            }
            if (listener instanceof ItemReadListener) {
                ItemReadListener readListener = (ItemReadListener)listener;
                this.readListeners.add(readListener);
            }
            if (listener instanceof ItemWriteListener) {
                ItemWriteListener writeListener = (ItemWriteListener)listener;
                this.writeListeners.add(writeListener);
            }
            if (!(listener instanceof ItemProcessListener)) continue;
            ItemProcessListener processListener = (ItemProcessListener)listener;
            this.processListeners.add(processListener);
        }
    }

    public void setNoRollbackExceptionClasses(Collection<Class<? extends Throwable>> noRollbackExceptionClasses) {
        this.noRollbackExceptionClasses = noRollbackExceptionClasses;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    protected Integer getCommitInterval() {
        return this.commitInterval;
    }

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.readerTransactionalQueue = isReaderTransactionalQueue;
    }

    public void setProcessorTransactional(Boolean processorTransactional) {
        this.processorTransactional = processorTransactional;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkipPolicy(SkipPolicy skipPolicy) {
        this.skipPolicy = skipPolicy;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setThrottleLimit(Integer throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    public void setItemReader(ItemReader<? extends I> itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setRetryListeners(RetryListener ... retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkippableExceptionClasses(Map<Class<? extends Throwable>, Boolean> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setRetryableExceptionClasses(Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setHasChunkElement(boolean hasChunkElement) {
        this.hasChunkElement = hasChunkElement;
    }

    protected boolean hasChunkElement() {
        return this.hasChunkElement;
    }

    protected boolean hasTasklet() {
        return this.tasklet != null;
    }

    protected boolean hasPartitionElement() {
        return this.partitionHandler != null;
    }
}

