/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.DefaultJobKeyGenerator;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcJobInstanceDao
extends AbstractJdbcBatchMetadataDao
implements JobInstanceDao,
InitializingBean {
    private static final String STAR_WILDCARD = "*";
    private static final String SQL_WILDCARD = "%";
    private static final String CREATE_JOB_INSTANCE = "INSERT INTO %PREFIX%JOB_INSTANCE(JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, VERSION)\n\tVALUES (?, ?, ?, ?)\n";
    private static final String FIND_JOBS_WITH_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME\nFROM %PREFIX%JOB_INSTANCE\nWHERE JOB_NAME = ?\n";
    private static final String FIND_JOBS_WITH_KEY = "SELECT JOB_INSTANCE_ID, JOB_NAME\nFROM %PREFIX%JOB_INSTANCE\nWHERE JOB_NAME = ?\n and JOB_KEY = ?";
    private static final String COUNT_JOBS_WITH_NAME = "SELECT COUNT(*)\nFROM %PREFIX%JOB_INSTANCE\nWHERE JOB_NAME = ?\n";
    private static final String FIND_JOBS_WITH_EMPTY_KEY = "SELECT JOB_INSTANCE_ID, JOB_NAME\nFROM %PREFIX%JOB_INSTANCE\nWHERE JOB_NAME = ? AND (JOB_KEY = ? OR JOB_KEY IS NULL)\n";
    private static final String GET_JOB_FROM_ID = "SELECT JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, VERSION\nFROM %PREFIX%JOB_INSTANCE\nWHERE JOB_INSTANCE_ID = ?\n";
    private static final String GET_JOB_FROM_EXECUTION_ID = "SELECT JI.JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, JI.VERSION\nFROM %PREFIX%JOB_INSTANCE JI, %PREFIX%JOB_EXECUTION JE\nWHERE JOB_EXECUTION_ID = ? AND JI.JOB_INSTANCE_ID = JE.JOB_INSTANCE_ID\n";
    private static final String FIND_JOB_NAMES = "SELECT DISTINCT JOB_NAME\nFROM %PREFIX%JOB_INSTANCE\nORDER BY JOB_NAME\n";
    private static final String FIND_LAST_JOBS_BY_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME\nFROM %PREFIX%JOB_INSTANCE\nWHERE JOB_NAME = ?\nORDER BY JOB_INSTANCE_ID DESC\n";
    private static final String FIND_LAST_JOB_INSTANCE_BY_JOB_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME\nFROM %PREFIX%JOB_INSTANCE I1\nWHERE I1.JOB_NAME = ? AND I1.JOB_INSTANCE_ID = (SELECT MAX(I2.JOB_INSTANCE_ID) FROM %PREFIX%JOB_INSTANCE I2 WHERE I2.JOB_NAME = ?)\n";
    private static final String FIND_LAST_JOBS_LIKE_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME\nFROM %PREFIX%JOB_INSTANCE\nWHERE JOB_NAME LIKE ? ORDER BY JOB_INSTANCE_ID DESC\n";
    private static final String DELETE_JOB_INSTANCE = "DELETE FROM %PREFIX%JOB_INSTANCE\nWHERE JOB_INSTANCE_ID = ?\n";
    private DataFieldMaxValueIncrementer jobInstanceIncrementer;
    private JobKeyGenerator<JobParameters> jobKeyGenerator = new DefaultJobKeyGenerator();

    @Override
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        Long jobInstanceId = this.jobInstanceIncrementer.nextLongValue();
        JobInstance jobInstance = new JobInstance(jobInstanceId, jobName);
        jobInstance.incrementVersion();
        Object[] parameters = new Object[]{jobInstanceId, jobName, this.jobKeyGenerator.generateKey(jobParameters), jobInstance.getVersion()};
        this.getJdbcTemplate().update(this.getQuery(CREATE_JOB_INSTANCE), parameters, new int[]{-5, 12, 12, 4});
        return jobInstance;
    }

    @Override
    @Nullable
    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        String jobKey = this.jobKeyGenerator.generateKey(jobParameters);
        JobInstanceRowMapper rowMapper = new JobInstanceRowMapper();
        List instances = StringUtils.hasLength((String)jobKey) ? this.getJdbcTemplate().query(this.getQuery(FIND_JOBS_WITH_KEY), (RowMapper)rowMapper, new Object[]{jobName, jobKey}) : this.getJdbcTemplate().query(this.getQuery(FIND_JOBS_WITH_EMPTY_KEY), (RowMapper)rowMapper, new Object[]{jobName, jobKey});
        if (instances.isEmpty()) {
            return null;
        }
        Assert.state((instances.size() == 1 ? 1 : 0) != 0, (String)("instance count must be 1 but was " + instances.size()));
        return (JobInstance)instances.get(0);
    }

    @Override
    @Nullable
    public JobInstance getJobInstance(@Nullable Long instanceId) {
        try {
            return (JobInstance)this.getJdbcTemplate().queryForObject(this.getQuery(GET_JOB_FROM_ID), (RowMapper)new JobInstanceRowMapper(), new Object[]{instanceId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<String> getJobNames() {
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_NAMES), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        });
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName, final int start, final int count) {
        ResultSetExtractor<List<JobInstance>> extractor = new ResultSetExtractor<List<JobInstance>>(){
            private List<JobInstance> list = new ArrayList<JobInstance>();

            public List<JobInstance> extractData(ResultSet rs) throws SQLException, DataAccessException {
                int rowNum;
                for (rowNum = 0; rowNum < start && rs.next(); ++rowNum) {
                }
                while (rowNum < start + count && rs.next()) {
                    JobInstanceRowMapper rowMapper = new JobInstanceRowMapper();
                    this.list.add((JobInstance)rowMapper.mapRow(rs, rowNum));
                    ++rowNum;
                }
                return this.list;
            }
        };
        List result = (List)this.getJdbcTemplate().query(this.getQuery(FIND_LAST_JOBS_BY_NAME), (ResultSetExtractor)extractor, new Object[]{jobName});
        return result;
    }

    @Override
    @Nullable
    public JobInstance getLastJobInstance(String jobName) {
        try {
            return (JobInstance)this.getJdbcTemplate().queryForObject(this.getQuery(FIND_LAST_JOB_INSTANCE_BY_JOB_NAME), (RowMapper)new JobInstanceRowMapper(), new Object[]{jobName, jobName});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public JobInstance getJobInstance(JobExecution jobExecution) {
        try {
            return (JobInstance)this.getJdbcTemplate().queryForObject(this.getQuery(GET_JOB_FROM_EXECUTION_ID), (RowMapper)new JobInstanceRowMapper(), new Object[]{jobExecution.getId()});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public long getJobInstanceCount(@Nullable String jobName) throws NoSuchJobException {
        try {
            return (Long)this.getJdbcTemplate().queryForObject(this.getQuery(COUNT_JOBS_WITH_NAME), Long.class, new Object[]{jobName});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchJobException("No job instances were found for job name " + jobName);
        }
    }

    @Override
    public void deleteJobInstance(JobInstance jobInstance) {
        this.getJdbcTemplate().update(this.getQuery(DELETE_JOB_INSTANCE), new Object[]{jobInstance.getId()});
    }

    @Deprecated
    public void setJobIncrementer(DataFieldMaxValueIncrementer jobIncrementer) {
        this.setJobInstanceIncrementer(jobIncrementer);
    }

    public void setJobInstanceIncrementer(DataFieldMaxValueIncrementer jobInstanceIncrementer) {
        this.jobInstanceIncrementer = jobInstanceIncrementer;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.jobInstanceIncrementer != null ? 1 : 0) != 0, (String)"jobInstanceIncrementer is required");
    }

    @Override
    public List<JobInstance> findJobInstancesByName(String jobName, final int start, final int count) {
        ResultSetExtractor extractor = new ResultSetExtractor(){
            private List<JobInstance> list = new ArrayList<JobInstance>();

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                int rowNum;
                for (rowNum = 0; rowNum < start && rs.next(); ++rowNum) {
                }
                while (rowNum < start + count && rs.next()) {
                    JobInstanceRowMapper rowMapper = new JobInstanceRowMapper();
                    this.list.add((JobInstance)rowMapper.mapRow(rs, rowNum));
                    ++rowNum;
                }
                return this.list;
            }
        };
        if (jobName.contains(STAR_WILDCARD)) {
            jobName = jobName.replaceAll("\\*", SQL_WILDCARD);
        }
        List result = (List)this.getJdbcTemplate().query(this.getQuery(FIND_LAST_JOBS_LIKE_NAME), extractor, new Object[]{jobName});
        return result;
    }

    private final class JobInstanceRowMapper
    implements RowMapper<JobInstance> {
        public JobInstance mapRow(ResultSet rs, int rowNum) throws SQLException {
            JobInstance jobInstance = new JobInstance(rs.getLong(1), rs.getString(2));
            jobInstance.incrementVersion();
            return jobInstance;
        }
    }
}

