/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.builder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.annotation.AfterProcess;
import org.springframework.batch.core.annotation.AfterRead;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeProcess;
import org.springframework.batch.core.annotation.BeforeRead;
import org.springframework.batch.core.annotation.BeforeWrite;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.annotation.OnReadError;
import org.springframework.batch.core.annotation.OnWriteError;
import org.springframework.batch.core.listener.StepListenerFactoryBean;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.support.ReflectionUtils;
import org.springframework.util.Assert;

public class SimpleStepBuilder<I, O>
extends AbstractTaskletStepBuilder<SimpleStepBuilder<I, O>> {
    private static final int DEFAULT_COMMIT_INTERVAL = 1;
    private ItemReader<? extends I> reader;
    private ItemWriter<? super O> writer;
    private ItemProcessor<? super I, ? extends O> processor;
    private int chunkSize = 0;
    private RepeatOperations chunkOperations;
    private CompletionPolicy completionPolicy;
    private Set<StepListener> itemListeners = new LinkedHashSet<StepListener>();
    private boolean readerTransactionalQueue = false;
    private MeterRegistry meterRegistry = Metrics.globalRegistry;

    public SimpleStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    protected SimpleStepBuilder(SimpleStepBuilder<I, O> parent) {
        super(parent);
        this.chunkSize = parent.chunkSize;
        this.completionPolicy = parent.completionPolicy;
        this.chunkOperations = parent.chunkOperations;
        this.reader = parent.reader;
        this.writer = parent.writer;
        this.processor = parent.processor;
        this.itemListeners = parent.itemListeners;
        this.readerTransactionalQueue = parent.readerTransactionalQueue;
        this.meterRegistry = parent.meterRegistry;
        this.transactionManager(parent.getTransactionManager());
    }

    public FaultTolerantStepBuilder<I, O> faultTolerant() {
        return new FaultTolerantStepBuilder(this);
    }

    @Override
    public TaskletStep build() {
        this.registerStepListenerAsItemListener();
        this.registerAsStreamsAndListeners(this.reader, this.processor, this.writer);
        return super.build();
    }

    protected void registerStepListenerAsItemListener() {
        for (StepExecutionListener stepExecutionListener : this.properties.getStepExecutionListeners()) {
            this.checkAndAddItemListener(stepExecutionListener);
        }
        for (ChunkListener chunkListener : this.chunkListeners) {
            this.checkAndAddItemListener(chunkListener);
        }
    }

    private void checkAndAddItemListener(StepListener stepListener) {
        if (stepListener instanceof ItemReadListener) {
            this.listener((ItemReadListener)stepListener);
        }
        if (stepListener instanceof ItemProcessListener) {
            this.listener((ItemProcessListener)stepListener);
        }
        if (stepListener instanceof ItemWriteListener) {
            this.listener((ItemWriteListener)stepListener);
        }
    }

    @Override
    protected Tasklet createTasklet() {
        Assert.state((this.reader != null ? 1 : 0) != 0, (String)"ItemReader must be provided");
        Assert.state((this.writer != null ? 1 : 0) != 0, (String)"ItemWriter must be provided");
        RepeatOperations repeatOperations = this.createChunkOperations();
        SimpleChunkProvider<I> chunkProvider = new SimpleChunkProvider<I>(this.getReader(), repeatOperations);
        SimpleChunkProcessor<I, O> chunkProcessor = new SimpleChunkProcessor<I, O>(this.getProcessor(), this.getWriter());
        chunkProvider.setListeners(new ArrayList<StepListener>(this.itemListeners));
        chunkProvider.setMeterRegistry(this.meterRegistry);
        chunkProcessor.setListeners(new ArrayList<StepListener>(this.itemListeners));
        chunkProcessor.setMeterRegistry(this.meterRegistry);
        ChunkOrientedTasklet<I> tasklet = new ChunkOrientedTasklet<I>(chunkProvider, chunkProcessor);
        tasklet.setBuffering(!this.readerTransactionalQueue);
        return tasklet;
    }

    public SimpleStepBuilder<I, O> chunk(int chunkSize) {
        Assert.state((this.completionPolicy == null || chunkSize == 0 ? 1 : 0) != 0, (String)"You must specify either a chunkCompletionPolicy or a commitInterval but not both.");
        this.chunkSize = chunkSize;
        return this;
    }

    public SimpleStepBuilder<I, O> chunk(CompletionPolicy completionPolicy) {
        Assert.state((this.chunkSize == 0 || completionPolicy == null ? 1 : 0) != 0, (String)"You must specify either a chunkCompletionPolicy or a commitInterval but not both.");
        this.completionPolicy = completionPolicy;
        return this;
    }

    public SimpleStepBuilder<I, O> reader(ItemReader<? extends I> reader) {
        this.reader = reader;
        return this;
    }

    public SimpleStepBuilder<I, O> writer(ItemWriter<? super O> writer) {
        this.writer = writer;
        return this;
    }

    public SimpleStepBuilder<I, O> processor(ItemProcessor<? super I, ? extends O> processor) {
        this.processor = processor;
        return this;
    }

    public SimpleStepBuilder<I, O> readerIsTransactionalQueue() {
        this.readerTransactionalQueue = true;
        return this;
    }

    @Override
    public SimpleStepBuilder<I, O> listener(Object listener) {
        super.listener(listener);
        HashSet itemListenerMethods = new HashSet();
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), BeforeRead.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), AfterRead.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), BeforeProcess.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), AfterProcess.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), BeforeWrite.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), AfterWrite.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), OnReadError.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), OnProcessError.class));
        itemListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), OnWriteError.class));
        if (itemListenerMethods.size() > 0) {
            StepListenerFactoryBean factory = new StepListenerFactoryBean();
            factory.setDelegate(listener);
            this.itemListeners.add((StepListener)factory.getObject());
        }
        return this;
    }

    public SimpleStepBuilder<I, O> listener(ItemReadListener<? super I> listener) {
        this.itemListeners.add(listener);
        return this;
    }

    public SimpleStepBuilder<I, O> listener(ItemWriteListener<? super O> listener) {
        this.itemListeners.add(listener);
        return this;
    }

    public SimpleStepBuilder<I, O> listener(ItemProcessListener<? super I, ? super O> listener) {
        this.itemListeners.add(listener);
        return this;
    }

    public SimpleStepBuilder<I, O> chunkOperations(RepeatOperations repeatTemplate) {
        this.chunkOperations = repeatTemplate;
        return this;
    }

    @Override
    protected SimpleStepBuilder<I, O> self() {
        return this;
    }

    protected RepeatOperations createChunkOperations() {
        RepeatOperations repeatOperations = this.chunkOperations;
        if (repeatOperations == null) {
            RepeatTemplate repeatTemplate = new RepeatTemplate();
            repeatTemplate.setCompletionPolicy(this.getChunkCompletionPolicy());
            repeatOperations = repeatTemplate;
        }
        return repeatOperations;
    }

    protected ItemReader<? extends I> getReader() {
        return this.reader;
    }

    protected ItemWriter<? super O> getWriter() {
        return this.writer;
    }

    protected ItemProcessor<? super I, ? extends O> getProcessor() {
        return this.processor;
    }

    protected int getChunkSize() {
        return this.chunkSize;
    }

    protected boolean isReaderTransactionalQueue() {
        return this.readerTransactionalQueue;
    }

    protected Set<StepListener> getItemListeners() {
        return this.itemListeners;
    }

    protected CompletionPolicy getChunkCompletionPolicy() {
        Assert.state((this.completionPolicy == null || this.chunkSize <= 0 ? 1 : 0) != 0, (String)"You must specify either a chunkCompletionPolicy or a commitInterval but not both.");
        Assert.state((this.chunkSize >= 0 ? 1 : 0) != 0, (String)"The commitInterval must be positive or zero (for default value).");
        if (this.completionPolicy != null) {
            return this.completionPolicy;
        }
        if (this.chunkSize == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Setting commit interval to default value (1)");
            }
            this.chunkSize = 1;
        }
        return new SimpleCompletionPolicy(this.chunkSize);
    }

    protected void registerAsStreamsAndListeners(ItemReader<? extends I> itemReader, ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter) {
        for (Object itemHandler : new Object[]{itemReader, itemWriter, itemProcessor}) {
            if (itemHandler instanceof ItemStream) {
                this.stream((ItemStream)itemHandler);
            }
            if (!StepListenerFactoryBean.isListener(itemHandler)) continue;
            StepListener listener = StepListenerFactoryBean.getListener(itemHandler);
            if (listener instanceof StepExecutionListener) {
                this.listener((StepExecutionListener)listener);
            }
            if (listener instanceof ChunkListener) {
                this.listener((ChunkListener)listener);
            }
            if (!(listener instanceof ItemReadListener) && !(listener instanceof ItemProcessListener) && !(listener instanceof ItemWriteListener)) continue;
            this.itemListeners.add(listener);
        }
    }
}

