/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.FlowBuilderException;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.DefaultStateTransitionComparator;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.batch.core.job.flow.support.state.DecisionState;
import org.springframework.batch.core.job.flow.support.state.EndState;
import org.springframework.batch.core.job.flow.support.state.FlowState;
import org.springframework.batch.core.job.flow.support.state.SplitState;
import org.springframework.batch.core.job.flow.support.state.StepState;
import org.springframework.core.task.TaskExecutor;

public class FlowBuilder<Q> {
    private final String name;
    private final String prefix;
    private final List<StateTransition> transitions = new ArrayList<StateTransition>();
    private final Map<String, State> tos = new HashMap<String, State>();
    private State currentState;
    private final EndState failedState;
    private final EndState completedState;
    private final EndState stoppedState;
    private int stepCounter = 0;
    private int flowCounter = 0;
    private int decisionCounter = 0;
    private int splitCounter = 0;
    private int endCounter = 0;
    private final Map<Object, State> states = new HashMap<Object, State>();
    private SimpleFlow flow;
    private boolean dirty = true;

    public FlowBuilder(String name) {
        this.name = name;
        this.prefix = name + ".";
        this.failedState = new EndState(FlowExecutionStatus.FAILED, this.prefix + "FAILED");
        this.completedState = new EndState(FlowExecutionStatus.COMPLETED, this.prefix + "COMPLETED");
        this.stoppedState = new EndState(FlowExecutionStatus.STOPPED, this.prefix + "STOPPED");
    }

    public Q build() {
        Flow result = this.flow();
        return (Q)result;
    }

    public FlowBuilder<Q> next(Step step) {
        this.doNext(step);
        return this;
    }

    public FlowBuilder<Q> start(Step step) {
        this.doStart(step);
        return this;
    }

    public FlowBuilder<Q> from(Step step) {
        this.doFrom(step);
        return this;
    }

    public UnterminatedFlowBuilder<Q> next(JobExecutionDecider decider) {
        this.doNext(decider);
        return new UnterminatedFlowBuilder(this);
    }

    public UnterminatedFlowBuilder<Q> start(JobExecutionDecider decider) {
        this.doStart(decider);
        return new UnterminatedFlowBuilder(this);
    }

    public UnterminatedFlowBuilder<Q> from(JobExecutionDecider decider) {
        this.doFrom(decider);
        return new UnterminatedFlowBuilder(this);
    }

    public FlowBuilder<Q> next(Flow flow) {
        this.doNext(flow);
        return this;
    }

    public FlowBuilder<Q> from(Flow flow) {
        this.doFrom(flow);
        return this;
    }

    public FlowBuilder<Q> start(Flow flow) {
        this.doStart(flow);
        return this;
    }

    public SplitBuilder<Q> split(TaskExecutor executor) {
        return new SplitBuilder(this, executor);
    }

    public TransitionBuilder<Q> on(String pattern) {
        return new TransitionBuilder(this, pattern);
    }

    public final Q end() {
        return this.build();
    }

    protected Flow flow() {
        if (!this.dirty) {
            return this.flow;
        }
        this.flow = new SimpleFlow(this.name);
        if (this.currentState instanceof FlowState && this.states.size() == 1) {
            return ((FlowState)this.currentState).getFlows().iterator().next();
        }
        this.addDanglingEndStates();
        this.flow.setStateTransitions(this.transitions);
        this.flow.setStateTransitionComparator(new DefaultStateTransitionComparator());
        this.dirty = false;
        return this.flow;
    }

    private void doNext(Object input) {
        if (this.currentState == null) {
            this.doStart(input);
        }
        State next = this.createState(input);
        this.addTransition("COMPLETED", next);
        this.addTransition("*", this.failedState);
        this.currentState = next;
    }

    private void doStart(Object input) {
        if (this.currentState != null) {
            this.doFrom(input);
        }
        this.currentState = this.createState(input);
    }

    private void doFrom(Object input) {
        if (this.currentState == null) {
            this.doStart(input);
        }
        State state = this.createState(input);
        this.tos.put(this.currentState.getName(), this.currentState);
        this.currentState = state;
    }

    private State createState(Object input) {
        State result;
        if (input instanceof Step) {
            if (!this.states.containsKey(input)) {
                Step step = (Step)input;
                this.states.put(input, new StepState(this.prefix + "step" + this.stepCounter++, step));
            }
            result = this.states.get(input);
        } else if (input instanceof JobExecutionDecider) {
            if (!this.states.containsKey(input)) {
                this.states.put(input, new DecisionState((JobExecutionDecider)input, this.prefix + "decision" + this.decisionCounter++));
            }
            result = this.states.get(input);
        } else if (input instanceof Flow) {
            if (!this.states.containsKey(input)) {
                this.states.put(input, new FlowState((Flow)input, this.prefix + "flow" + this.flowCounter++));
            }
            result = this.states.get(input);
        } else {
            throw new FlowBuilderException("No state can be created for: " + input);
        }
        this.dirty = true;
        return result;
    }

    private SplitState createState(Collection<Flow> flows, TaskExecutor executor) {
        if (!this.states.containsKey(flows)) {
            this.states.put(flows, new SplitState(flows, this.prefix + "split" + this.splitCounter++));
        }
        SplitState result = (SplitState)this.states.get(flows);
        if (executor != null) {
            result.setTaskExecutor(executor);
        }
        this.dirty = true;
        return result;
    }

    private void addDanglingEndStates() {
        HashSet<String> froms = new HashSet<String>();
        for (StateTransition transition : this.transitions) {
            froms.add(transition.getState().getName());
        }
        if (this.tos.isEmpty() && this.currentState != null) {
            this.tos.put(this.currentState.getName(), this.currentState);
        }
        HashMap<String, State> copy = new HashMap<String, State>(this.tos);
        for (String to : copy.keySet()) {
            if (froms.contains(to)) continue;
            this.currentState = (State)copy.get(to);
            if (this.currentState.isEndState()) continue;
            this.addTransition("COMPLETED", this.completedState);
            this.addTransition("*", this.failedState);
        }
        copy = new HashMap<String, State>(this.tos);
        for (String from : copy.keySet()) {
            this.currentState = (State)copy.get(from);
            if (this.currentState.isEndState()) continue;
            if (!this.hasFail(from)) {
                this.addTransition("*", this.failedState);
            }
            if (this.hasCompleted(from)) continue;
            this.addTransition("*", this.completedState);
        }
    }

    private boolean hasFail(String from) {
        return this.matches(from, "FAILED");
    }

    private boolean hasCompleted(String from) {
        return this.matches(from, "COMPLETED");
    }

    private boolean matches(String from, String status) {
        for (StateTransition transition : this.transitions) {
            if (!from.equals(transition.getState().getName()) || !transition.matches(status)) continue;
            return true;
        }
        return false;
    }

    private void addTransition(String pattern, State next) {
        this.tos.put(next.getName(), next);
        this.transitions.add(StateTransition.createStateTransition(this.currentState, pattern, next.getName()));
        if (this.transitions.size() == 1) {
            this.transitions.add(StateTransition.createEndStateTransition(this.failedState));
            this.transitions.add(StateTransition.createEndStateTransition(this.completedState));
            this.transitions.add(StateTransition.createEndStateTransition(this.stoppedState));
        }
        if (next.isEndState()) {
            this.transitions.add(StateTransition.createEndStateTransition(next));
        }
        this.dirty = true;
    }

    protected void stop(String pattern) {
        this.addTransition(pattern, this.stoppedState);
    }

    protected void stop(String pattern, State restart) {
        EndState next = new EndState(FlowExecutionStatus.STOPPED, "STOPPED", this.prefix + "stop" + this.endCounter++, true);
        this.addTransition(pattern, next);
        this.currentState = next;
        this.addTransition("*", restart);
    }

    private void end(String pattern) {
        this.addTransition(pattern, this.completedState);
    }

    private void end(String pattern, String code) {
        this.addTransition(pattern, new EndState(FlowExecutionStatus.COMPLETED, code, this.prefix + "end" + this.endCounter++));
    }

    private void fail(String pattern) {
        this.addTransition(pattern, this.failedState);
    }

    public static class UnterminatedFlowBuilder<Q> {
        private final FlowBuilder<Q> parent;

        public UnterminatedFlowBuilder(FlowBuilder<Q> parent) {
            this.parent = parent;
        }

        public TransitionBuilder<Q> on(String pattern) {
            return new TransitionBuilder<Q>(this.parent, pattern);
        }
    }

    public static class SplitBuilder<Q> {
        private final FlowBuilder<Q> parent;
        private final TaskExecutor executor;

        public SplitBuilder(FlowBuilder<Q> parent, TaskExecutor executor) {
            this.parent = parent;
            this.executor = executor;
        }

        public FlowBuilder<Q> add(Flow ... flows) {
            ArrayList<Flow> list = new ArrayList<Flow>(Arrays.asList(flows));
            String name = "split" + this.parent.splitCounter++;
            int counter = 0;
            State one = this.parent.currentState;
            Flow flow = null;
            if (one != null && !(one instanceof FlowState)) {
                FlowBuilder stateBuilder = new FlowBuilder(name + "_" + counter++);
                stateBuilder.currentState = one;
                flow = (Flow)stateBuilder.build();
            } else if (one instanceof FlowState && this.parent.states.size() == 1) {
                list.add(((FlowState)one).getFlows().iterator().next());
            }
            if (flow != null) {
                list.add(flow);
            }
            SplitState next = this.parent.createState(list, this.executor);
            this.parent.currentState = next;
            return this.parent;
        }
    }

    public static class TransitionBuilder<Q> {
        private final FlowBuilder<Q> parent;
        private final String pattern;

        public TransitionBuilder(FlowBuilder<Q> parent, String pattern) {
            this.parent = parent;
            this.pattern = pattern;
        }

        public FlowBuilder<Q> to(Step step) {
            State next = this.parent.createState(step);
            this.parent.addTransition(this.pattern, next);
            this.parent.currentState = next;
            return this.parent;
        }

        public FlowBuilder<Q> to(Flow flow) {
            State next = this.parent.createState(flow);
            this.parent.addTransition(this.pattern, next);
            this.parent.currentState = next;
            return this.parent;
        }

        public FlowBuilder<Q> to(JobExecutionDecider decider) {
            State next = this.parent.createState(decider);
            this.parent.addTransition(this.pattern, next);
            this.parent.currentState = next;
            return this.parent;
        }

        public FlowBuilder<Q> stop() {
            this.parent.stop(this.pattern);
            return this.parent;
        }

        public FlowBuilder<Q> stopAndRestart(Flow flow) {
            State next = this.parent.createState(flow);
            this.parent.stop(this.pattern, next);
            return this.parent;
        }

        public FlowBuilder<Q> stopAndRestart(JobExecutionDecider decider) {
            State next = this.parent.createState(decider);
            this.parent.stop(this.pattern, next);
            return this.parent;
        }

        public FlowBuilder<Q> stopAndRestart(Step restart) {
            State next = this.parent.createState(restart);
            this.parent.stop(this.pattern, next);
            return this.parent;
        }

        public FlowBuilder<Q> end() {
            this.parent.end(this.pattern);
            return this.parent;
        }

        public FlowBuilder<Q> end(String status) {
            this.parent.end(this.pattern, status);
            return this.parent;
        }

        public FlowBuilder<Q> fail() {
            this.parent.fail(this.pattern);
            return this.parent;
        }
    }
}

