/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class Jackson2ExecutionContextStringSerializer
implements ExecutionContextSerializer {
    private static final String IDENTIFYING_KEY_NAME = "identifying";
    private static final String TYPE_KEY_NAME = "type";
    private static final String VALUE_KEY_NAME = "value";
    private ObjectMapper objectMapper;

    public Jackson2ExecutionContextStringSerializer(String ... trustedClassNames) {
        this.objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true)).configure(MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES, true)).setDefaultTyping(Jackson2ExecutionContextStringSerializer.createTrustedDefaultTyping(trustedClassNames))).addModule((Module)new JobParametersModule())).build();
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper.copy();
        this.objectMapper.registerModule((Module)new JobParametersModule());
    }

    public Map<String, Object> deserialize(InputStream in) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (Map)this.objectMapper.readValue(in, (TypeReference)typeRef);
    }

    public void serialize(Map<String, Object> context, OutputStream out) throws IOException {
        Assert.notNull(context, (String)"A context is required");
        Assert.notNull((Object)out, (String)"An OutputStream is required");
        this.objectMapper.writeValue(out, context);
    }

    private static TypeResolverBuilder<? extends TypeResolverBuilder> createTrustedDefaultTyping(String[] trustedClassNames) {
        TrustedTypeResolverBuilder result = new TrustedTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, trustedClassNames);
        result = result.init(JsonTypeInfo.Id.CLASS, null);
        result = result.inclusion(JsonTypeInfo.As.PROPERTY);
        return result;
    }

    private class JobParametersModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        private JobParametersModule() {
            super("Job parameters module");
            this.setMixInAnnotation(JobParameters.class, JobParametersMixIn.class);
            this.addDeserializer(JobParameter.class, (JsonDeserializer)new JobParameterDeserializer());
            this.addSerializer(JobParameter.class, (JsonSerializer)new JobParameterSerializer(JobParameter.class));
        }

        private abstract class JobParametersMixIn {
            private JobParametersMixIn() {
            }

            @JsonIgnore
            abstract boolean isEmpty();

            @JsonIgnore
            abstract Map<String, JobParameter<?>> getIdentifyingParameters();
        }

        private class JobParameterDeserializer
        extends StdDeserializer<JobParameter> {
            private static final long serialVersionUID = 1L;

            JobParameterDeserializer() {
                super(JobParameter.class);
            }

            public JobParameter deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                JsonNode node = (JsonNode)parser.readValueAsTree();
                boolean identifying = node.get(Jackson2ExecutionContextStringSerializer.IDENTIFYING_KEY_NAME).asBoolean();
                String type = node.get(Jackson2ExecutionContextStringSerializer.TYPE_KEY_NAME).asText();
                JsonNode value = node.get(Jackson2ExecutionContextStringSerializer.VALUE_KEY_NAME);
                try {
                    Class<?> parameterType = Class.forName(type);
                    Object typedValue = Jackson2ExecutionContextStringSerializer.this.objectMapper.convertValue((Object)value, parameterType);
                    return new JobParameter<Object>(typedValue, parameterType, identifying);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to deserialize job parameter " + value.asText(), e);
                }
            }
        }

        private class JobParameterSerializer
        extends StdSerializer<JobParameter> {
            protected JobParameterSerializer(Class<JobParameter> type) {
                super(type);
            }

            public void serializeWithType(JobParameter value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
                WritableTypeId typeId = typeSer.typeId((Object)value, JsonToken.START_OBJECT);
                typeSer.writeTypePrefix(gen, typeId);
                this.serialize(value, gen, provider);
                typeSer.writeTypeSuffix(gen, typeId);
            }

            public void serialize(JobParameter jobParameter, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeFieldName(Jackson2ExecutionContextStringSerializer.VALUE_KEY_NAME);
                jsonGenerator.writeObject(jobParameter.getValue());
                jsonGenerator.writeFieldName(Jackson2ExecutionContextStringSerializer.TYPE_KEY_NAME);
                jsonGenerator.writeString(jobParameter.getType().getName());
                jsonGenerator.writeFieldName(Jackson2ExecutionContextStringSerializer.IDENTIFYING_KEY_NAME);
                jsonGenerator.writeObject((Object)jobParameter.isIdentifying());
            }
        }
    }

    static class TrustedTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        private final String[] trustedClassNames;

        TrustedTypeResolverBuilder(ObjectMapper.DefaultTyping defaultTyping, String[] trustedClassNames) {
            super(defaultTyping, (PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfSubType(Object.class).build());
            this.trustedClassNames = trustedClassNames != null ? Arrays.copyOf(trustedClassNames, trustedClassNames.length) : null;
        }

        protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
            TypeIdResolver result = super.idResolver(config, baseType, subtypeValidator, subtypes, forSer, forDeser);
            return new TrustedTypeIdResolver(result, this.trustedClassNames);
        }
    }

    static class TrustedTypeIdResolver
    implements TypeIdResolver {
        private static final Set<String> TRUSTED_CLASS_NAMES = Set.of("javax.xml.namespace.QName", "java.util.UUID", "java.util.ArrayList", "java.util.Arrays$ArrayList", "java.util.LinkedList", "java.util.Collections$EmptyList", "java.util.Collections$EmptyMap", "java.util.Collections$EmptySet", "java.util.Collections$UnmodifiableRandomAccessList", "java.util.Collections$UnmodifiableList", "java.util.Collections$UnmodifiableMap", "java.util.Collections$UnmodifiableSet", "java.util.Collections$SingletonList", "java.util.Collections$SingletonMap", "java.util.Collections$SingletonSet", "java.util.Date", "java.time.Instant", "java.time.Duration", "java.time.LocalDate", "java.time.LocalTime", "java.time.LocalDateTime", "java.sql.Timestamp", "java.net.URL", "java.util.TreeMap", "java.util.HashMap", "java.util.LinkedHashMap", "java.util.TreeSet", "java.util.HashSet", "java.util.LinkedHashSet", "java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.math.BigDecimal", "java.math.BigInteger", "java.lang.String", "java.lang.Character", "java.lang.CharSequence", "java.util.Properties", "[Ljava.util.Properties;", "org.springframework.batch.core.JobParameter", "org.springframework.batch.core.JobParameters", "java.util.concurrent.ConcurrentHashMap", "java.sql.Date");
        private final Set<String> trustedClassNames = new LinkedHashSet<String>(TRUSTED_CLASS_NAMES);
        private final TypeIdResolver delegate;

        TrustedTypeIdResolver(TypeIdResolver delegate, String[] trustedClassNames) {
            this.delegate = delegate;
            if (trustedClassNames != null) {
                this.trustedClassNames.addAll(Arrays.asList(trustedClassNames));
            }
        }

        public void init(JavaType baseType) {
            this.delegate.init(baseType);
        }

        public String idFromValue(Object value) {
            return this.delegate.idFromValue(value);
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            return this.delegate.idFromValueAndType(value, suggestedType);
        }

        public String idFromBaseType() {
            return this.delegate.idFromBaseType();
        }

        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            boolean isExplicitMixin;
            DeserializationConfig config = (DeserializationConfig)context.getConfig();
            JavaType result = this.delegate.typeFromId(context, id);
            String className = result.getRawClass().getName();
            if (this.isTrusted(className)) {
                return result;
            }
            boolean bl = isExplicitMixin = config.findMixInClassFor(result.getRawClass()) != null;
            if (isExplicitMixin) {
                return result;
            }
            Class rawClass = result.getRawClass();
            JacksonAnnotation jacksonAnnotation = (JacksonAnnotation)AnnotationUtils.findAnnotation((Class)rawClass, JacksonAnnotation.class);
            if (jacksonAnnotation != null) {
                return result;
            }
            throw new IllegalArgumentException("The class with " + id + " and name of " + className + " is not trusted. If you believe this class is safe to deserialize, you can add it to the base set of trusted classes at construction time or provide an explicit mapping using Jackson annotations or a custom ObjectMapper. If the serialization is only done by a trusted source, you can also enable default typing.");
        }

        private boolean isTrusted(String id) {
            return this.trustedClassNames.contains(id);
        }

        public String getDescForKnownTypeIds() {
            return this.delegate.getDescForKnownTypeIds();
        }

        public JsonTypeInfo.Id getMechanism() {
            return this.delegate.getMechanism();
        }
    }
}

