/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.observability.BatchMetrics;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.item.SkipOverflowException;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.lang.Nullable;

public class SimpleChunkProvider<I>
implements ChunkProvider<I> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ItemReader<? extends I> itemReader;
    private final MulticasterBatchListener<I, ?> listener = new MulticasterBatchListener();
    private final RepeatOperations repeatOperations;
    private MeterRegistry meterRegistry = Metrics.globalRegistry;

    public SimpleChunkProvider(ItemReader<? extends I> itemReader, RepeatOperations repeatOperations) {
        this.itemReader = itemReader;
        this.repeatOperations = repeatOperations;
    }

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected MulticasterBatchListener<I, ?> getListener() {
        return this.listener;
    }

    @Nullable
    protected final I doRead() throws Exception {
        try {
            this.listener.beforeRead();
            Object item = this.itemReader.read();
            if (item != null) {
                this.listener.afterRead(item);
            }
            return (I)item;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(e.getMessage() + " : " + e.getClass().getName()));
            }
            this.listener.onReadError(e);
            throw e;
        }
    }

    @Override
    public Chunk<I> provide(StepContribution contribution) throws Exception {
        Chunk inputs = new Chunk(new Object[0]);
        this.repeatOperations.iterate(context -> {
            Object item = null;
            Timer.Sample sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
            String status = "SUCCESS";
            try {
                item = this.read(contribution, inputs);
            }
            catch (SkipOverflowException e) {
                status = "FAILURE";
                RepeatStatus repeatStatus = RepeatStatus.FINISHED;
                return repeatStatus;
            }
            finally {
                this.stopTimer(sample, contribution.getStepExecution(), status);
            }
            if (item == null) {
                inputs.setEnd();
                return RepeatStatus.FINISHED;
            }
            inputs.add(item);
            contribution.incrementReadCount();
            return RepeatStatus.CONTINUABLE;
        });
        return inputs;
    }

    private void stopTimer(Timer.Sample sample, StepExecution stepExecution, String status) {
        String fullyQualifiedMetricName = "spring.batch.item.read";
        sample.stop(BatchMetrics.createTimer(this.meterRegistry, "item.read", "Item reading duration", Tag.of((String)(fullyQualifiedMetricName + ".job.name"), (String)stepExecution.getJobExecution().getJobInstance().getJobName()), Tag.of((String)(fullyQualifiedMetricName + ".step.name"), (String)stepExecution.getStepName()), Tag.of((String)(fullyQualifiedMetricName + ".status"), (String)status)));
    }

    @Override
    public void postProcess(StepContribution contribution, Chunk<I> chunk) {
    }

    @Nullable
    protected I read(StepContribution contribution, Chunk<I> chunk) throws SkipOverflowException, Exception {
        return this.doRead();
    }
}

