/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.FlowHolder;
import org.springframework.batch.core.job.flow.support.state.AbstractState;
import org.springframework.batch.core.job.flow.support.state.FlowExecutionAggregator;
import org.springframework.batch.core.job.flow.support.state.MaxValueFlowExecutionAggregator;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;

public class SplitState
extends AbstractState
implements FlowHolder {
    private final Collection<Flow> flows;
    private final SplitState parentSplit;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();
    private final FlowExecutionAggregator aggregator = new MaxValueFlowExecutionAggregator();

    public SplitState(Collection<Flow> flows, String name) {
        this(flows, name, null);
    }

    public SplitState(Collection<Flow> flows, String name, @Nullable SplitState parentSplit) {
        super(name);
        this.flows = flows;
        this.parentSplit = parentSplit;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Override
    public Collection<Flow> getFlows() {
        return this.flows;
    }

    @Override
    public FlowExecutionStatus handle(FlowExecutor executor) throws Exception {
        ArrayList<FutureTask<FlowExecution>> tasks = new ArrayList<FutureTask<FlowExecution>>();
        for (Flow flow : this.flows) {
            FutureTask<FlowExecution> task = new FutureTask<FlowExecution>(() -> flow.start(executor));
            tasks.add(task);
            try {
                this.taskExecutor.execute((Runnable)task);
            }
            catch (TaskRejectedException taskRejectedException) {
                throw new FlowExecutionException("TaskExecutor rejected task for flow=" + flow.getName());
            }
        }
        FlowExecutionStatus parentSplitStatus = this.parentSplit == null ? null : this.parentSplit.handle(executor);
        ArrayList<FlowExecution> results = new ArrayList<FlowExecution>();
        for (Future future : tasks) {
            try {
                results.add((FlowExecution)future.get());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
        }
        FlowExecutionStatus flowExecutionStatus = this.doAggregation(results, executor);
        if (parentSplitStatus != null) {
            return Collections.max(Arrays.asList(flowExecutionStatus, parentSplitStatus));
        }
        return flowExecutionStatus;
    }

    protected FlowExecutionStatus doAggregation(Collection<FlowExecution> results, FlowExecutor executor) {
        return this.aggregator.aggregate(results);
    }

    @Override
    public boolean isEndState() {
        return false;
    }
}

