/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.partition.support.DefaultStepExecutionAggregator;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RemoteStepExecutionAggregator
implements StepExecutionAggregator,
InitializingBean {
    private StepExecutionAggregator delegate = new DefaultStepExecutionAggregator();
    private JobExplorer jobExplorer;

    public RemoteStepExecutionAggregator() {
    }

    public RemoteStepExecutionAggregator(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setDelegate(StepExecutionAggregator delegate) {
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer must be provided");
    }

    @Override
    public void aggregate(StepExecution result, Collection<StepExecution> executions) {
        Assert.notNull((Object)result, (String)"To aggregate into a result it must be non-null.");
        if (executions == null) {
            return;
        }
        Set stepExecutionIds = executions.stream().map(stepExecution -> {
            Long id = stepExecution.getId();
            Assert.state((id != null ? 1 : 0) != 0, (String)("StepExecution has null id. It must be saved first: " + stepExecution));
            return id;
        }).collect(Collectors.toSet());
        JobExecution jobExecution = this.jobExplorer.getJobExecution(result.getJobExecutionId());
        Assert.state((jobExecution != null ? 1 : 0) != 0, (String)("Could not load JobExecution from JobRepository for id " + result.getJobExecutionId()));
        List<StepExecution> updates = jobExecution.getStepExecutions().stream().filter(stepExecution -> stepExecutionIds.contains(stepExecution.getId())).collect(Collectors.toList());
        this.delegate.aggregate(result, updates);
    }
}

