/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.tasklet;

import java.io.File;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.CommandRunner;
import org.springframework.batch.core.step.tasklet.JvmCommandRunner;
import org.springframework.batch.core.step.tasklet.SimpleSystemProcessExitCodeMapper;
import org.springframework.batch.core.step.tasklet.StoppableTasklet;
import org.springframework.batch.core.step.tasklet.SystemCommandException;
import org.springframework.batch.core.step.tasklet.SystemProcessExitCodeMapper;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SystemCommandTasklet
implements StepExecutionListener,
StoppableTasklet,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(SystemCommandTasklet.class);
    private CommandRunner commandRunner = new JvmCommandRunner();
    private String[] cmdArray;
    private String[] environmentParams = null;
    private File workingDirectory = null;
    private SystemProcessExitCodeMapper systemProcessExitCodeMapper = new SimpleSystemProcessExitCodeMapper();
    private long timeout = 0L;
    private long checkInterval = 1000L;
    private StepExecution execution = null;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private boolean interruptOnCancel = false;
    private volatile boolean stopped = false;
    private JobExplorer jobExplorer;
    private boolean stoppable = false;

    @Override
    @Nullable
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        FutureTask<Integer> systemCommandTask = new FutureTask<Integer>(() -> {
            Process process = this.commandRunner.exec(this.cmdArray, this.environmentParams, this.workingDirectory);
            return process.waitFor();
        });
        long t0 = System.currentTimeMillis();
        this.taskExecutor.execute(systemCommandTask);
        do {
            JobExecution jobExecution;
            Thread.sleep(this.checkInterval);
            if (this.stoppable && (jobExecution = this.jobExplorer.getJobExecution(chunkContext.getStepContext().getStepExecution().getJobExecutionId())).isStopping()) {
                this.stopped = true;
            }
            if (systemCommandTask.isDone()) {
                contribution.setExitStatus(this.systemProcessExitCodeMapper.getExitStatus(systemCommandTask.get()));
                return RepeatStatus.FINISHED;
            }
            if (System.currentTimeMillis() - t0 > this.timeout) {
                systemCommandTask.cancel(this.interruptOnCancel);
                throw new SystemCommandException("Execution of system command did not finish within the timeout");
            }
            if (!this.execution.isTerminateOnly()) continue;
            systemCommandTask.cancel(this.interruptOnCancel);
            String command = String.join((CharSequence)" ", this.cmdArray);
            throw new JobInterruptedException("Job interrupted while executing system command '" + command + "'");
        } while (!this.stopped);
        systemCommandTask.cancel(this.interruptOnCancel);
        contribution.setExitStatus(ExitStatus.STOPPED);
        return RepeatStatus.FINISHED;
    }

    public void setCommandRunner(CommandRunner commandRunner) {
        this.commandRunner = commandRunner;
    }

    public void setCommand(String ... command) {
        this.cmdArray = command;
    }

    public void setEnvironmentParams(String[] envp) {
        this.environmentParams = envp;
    }

    public void setWorkingDirectory(String dir) {
        if (dir == null) {
            this.workingDirectory = null;
            return;
        }
        this.workingDirectory = new File(dir);
        Assert.isTrue((boolean)this.workingDirectory.exists(), (String)"working directory must exist");
        Assert.isTrue((boolean)this.workingDirectory.isDirectory(), (String)"working directory value must be a directory");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.commandRunner != null ? 1 : 0) != 0, (String)"CommandRunner must be set");
        Assert.state((this.cmdArray != null ? 1 : 0) != 0, (String)"'cmdArray' property value must not be null");
        Assert.state((!ObjectUtils.isEmpty((Object[])this.cmdArray) ? 1 : 0) != 0, (String)"'cmdArray' property value is required with at least 1 element");
        Assert.state((boolean)StringUtils.hasText((String)this.cmdArray[0]), (String)"'cmdArray' property value is required with at least 1 element");
        Assert.state((this.systemProcessExitCodeMapper != null ? 1 : 0) != 0, (String)"SystemProcessExitCodeMapper must be set");
        Assert.state((this.timeout > 0L ? 1 : 0) != 0, (String)"timeout value must be greater than zero");
        Assert.state((this.taskExecutor != null ? 1 : 0) != 0, (String)"taskExecutor is required");
        this.stoppable = this.jobExplorer != null;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setSystemProcessExitCodeMapper(SystemProcessExitCodeMapper systemProcessExitCodeMapper) {
        this.systemProcessExitCodeMapper = systemProcessExitCodeMapper;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTerminationCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.execution = stepExecution;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setInterruptOnCancel(boolean interruptOnCancel) {
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public void stop() {
        this.stopped = true;
    }
}

