/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.configuration.xml.DecisionParser;
import org.springframework.batch.core.configuration.xml.FlowElementParser;
import org.springframework.batch.core.configuration.xml.InlineStepParser;
import org.springframework.batch.core.configuration.xml.SimpleFlowFactoryBean;
import org.springframework.batch.core.configuration.xml.SplitParser;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractFlowParser
extends AbstractSingleBeanDefinitionParser {
    protected static final String ID_ATTR = "id";
    protected static final String STEP_ELE = "step";
    protected static final String FLOW_ELE = "flow";
    protected static final String DECISION_ELE = "decision";
    protected static final String SPLIT_ELE = "split";
    protected static final String NEXT_ATTR = "next";
    protected static final String NEXT_ELE = "next";
    protected static final String END_ELE = "end";
    protected static final String FAIL_ELE = "fail";
    protected static final String STOP_ELE = "stop";
    protected static final String ON_ATTR = "on";
    protected static final String TO_ATTR = "to";
    protected static final String RESTART_ATTR = "restart";
    protected static final String EXIT_CODE_ATTR = "exit-code";
    private static final InlineStepParser stepParser = new InlineStepParser();
    private static final FlowElementParser flowParser = new FlowElementParser();
    private static final DecisionParser decisionParser = new DecisionParser();
    protected static int endCounter = 0;
    private String jobFactoryRef;

    protected void setJobFactoryRef(String jobFactoryRef) {
        this.jobFactoryRef = jobFactoryRef;
    }

    protected Class<?> getBeanClass(Element element) {
        return SimpleFlowFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ArrayList<BeanDefinition> stateTransitions = new ArrayList<BeanDefinition>();
        SplitParser splitParser = new SplitParser(this.jobFactoryRef);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        boolean stepExists = false;
        LinkedHashMap<String, Set<String>> reachableElementMap = new LinkedHashMap<String, Set<String>>();
        String startElement = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String nodeName;
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            switch (nodeName = node.getLocalName()) {
                case "step": {
                    stateTransitions.addAll(stepParser.parse(child, parserContext, this.jobFactoryRef));
                    stepExists = true;
                    break;
                }
                case "decision": {
                    stateTransitions.addAll(decisionParser.parse(child, parserContext));
                    break;
                }
                case "flow": {
                    stateTransitions.addAll(flowParser.parse(child, parserContext));
                    stepExists = true;
                    break;
                }
                case "split": {
                    stateTransitions.addAll(splitParser.parse(child, new ParserContext(parserContext.getReaderContext(), parserContext.getDelegate(), (BeanDefinition)builder.getBeanDefinition())));
                    stepExists = true;
                }
            }
            if (!Arrays.asList(STEP_ELE, DECISION_ELE, SPLIT_ELE, FLOW_ELE).contains(nodeName)) continue;
            reachableElementMap.put(child.getAttribute(ID_ATTR), this.findReachableElements(child));
            if (startElement != null) continue;
            startElement = child.getAttribute(ID_ATTR);
        }
        String flowName = (String)builder.getRawBeanDefinition().getAttribute("flowName");
        if (!stepExists && !StringUtils.hasText((String)element.getAttribute("parent"))) {
            parserContext.getReaderContext().error("The flow [" + flowName + "] must contain at least one step, flow or split", (Object)element);
        }
        HashSet<String> allReachableElements = new HashSet<String>();
        this.findAllReachableElements(startElement, reachableElementMap, allReachableElements);
        for (String elementId : reachableElementMap.keySet()) {
            if (allReachableElements.contains(elementId)) continue;
            parserContext.getReaderContext().error("The element [" + elementId + "] is unreachable", (Object)element);
        }
        ManagedList managedList = new ManagedList();
        managedList.addAll(stateTransitions);
        builder.addPropertyValue("stateTransitions", (Object)managedList);
    }

    private Set<String> findReachableElements(Element element) {
        HashSet<String> reachableElements = new HashSet<String>();
        String nextAttribute = element.getAttribute("next");
        if (StringUtils.hasText((String)nextAttribute)) {
            reachableElements.add(nextAttribute);
        }
        List nextElements = DomUtils.getChildElementsByTagName((Element)element, (String)"next");
        for (Element nextElement : nextElements) {
            String toAttribute = nextElement.getAttribute(TO_ATTR);
            reachableElements.add(toAttribute);
        }
        List stopElements = DomUtils.getChildElementsByTagName((Element)element, (String)STOP_ELE);
        for (Element stopElement : stopElements) {
            String restartAttribute = stopElement.getAttribute(RESTART_ATTR);
            reachableElements.add(restartAttribute);
        }
        return reachableElements;
    }

    protected void findAllReachableElements(String startElement, Map<String, Set<String>> reachableElementMap, Set<String> accumulator) {
        Set<String> reachableIds = reachableElementMap.get(startElement);
        accumulator.add(startElement);
        if (reachableIds != null) {
            for (String reachable : reachableIds) {
                if (accumulator.contains(reachable)) continue;
                this.findAllReachableElements(reachable, reachableElementMap, accumulator);
            }
        }
    }

    public static Collection<BeanDefinition> getNextElements(ParserContext parserContext, BeanDefinition stateDef, Element element) {
        return AbstractFlowParser.getNextElements(parserContext, null, stateDef, element);
    }

    public static Collection<BeanDefinition> getNextElements(ParserContext parserContext, String stepId, BeanDefinition stateDef, Element element) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        String shortNextAttribute = element.getAttribute("next");
        boolean hasNextAttribute = StringUtils.hasText((String)shortNextAttribute);
        if (hasNextAttribute) {
            list.add(AbstractFlowParser.getStateTransitionReference(parserContext, stateDef, null, shortNextAttribute));
        }
        boolean transitionElementExists = false;
        ArrayList<String> patterns = new ArrayList<String>();
        for (String transitionName : new String[]{"next", STOP_ELE, END_ELE, FAIL_ELE}) {
            List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)transitionName);
            for (Element transitionElement : transitionElements) {
                AbstractFlowParser.verifyUniquePattern(transitionElement, patterns, element, parserContext);
                list.addAll(AbstractFlowParser.parseTransitionElement(transitionElement, stepId, stateDef, parserContext));
                transitionElementExists = true;
            }
        }
        if (!transitionElementExists) {
            list.addAll(AbstractFlowParser.createTransition(FlowExecutionStatus.FAILED, FlowExecutionStatus.FAILED.getName(), null, null, stateDef, parserContext, false));
            list.addAll(AbstractFlowParser.createTransition(FlowExecutionStatus.UNKNOWN, FlowExecutionStatus.UNKNOWN.getName(), null, null, stateDef, parserContext, false));
            if (!hasNextAttribute) {
                list.addAll(AbstractFlowParser.createTransition(FlowExecutionStatus.COMPLETED, null, null, null, stateDef, parserContext, false));
            }
        } else if (hasNextAttribute) {
            parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> may not contain a 'next' attribute and a transition element", (Object)element);
        }
        return list;
    }

    protected static void verifyUniquePattern(Element transitionElement, List<String> patterns, Element element, ParserContext parserContext) {
        String onAttribute = transitionElement.getAttribute(ON_ATTR);
        if (patterns.contains(onAttribute)) {
            parserContext.getReaderContext().error("Duplicate transition pattern found for '" + onAttribute + "'", (Object)element);
        }
        patterns.add(onAttribute);
    }

    private static Collection<BeanDefinition> parseTransitionElement(Element transitionElement, String stateId, BeanDefinition stateDef, ParserContext parserContext) {
        FlowExecutionStatus status = AbstractFlowParser.getBatchStatusFromEndTransitionName(transitionElement.getNodeName());
        String onAttribute = transitionElement.getAttribute(ON_ATTR);
        String restartAttribute = transitionElement.getAttribute(RESTART_ATTR);
        String nextAttribute = transitionElement.getAttribute(TO_ATTR);
        if (!StringUtils.hasText((String)nextAttribute)) {
            nextAttribute = restartAttribute;
        }
        boolean abandon = stateId != null && StringUtils.hasText((String)restartAttribute) && !restartAttribute.equals(stateId);
        String exitCodeAttribute = transitionElement.getAttribute(EXIT_CODE_ATTR);
        return AbstractFlowParser.createTransition(status, onAttribute, nextAttribute, exitCodeAttribute, stateDef, parserContext, abandon);
    }

    protected static Collection<BeanDefinition> createTransition(FlowExecutionStatus status, String on, String next, String exitCode, BeanDefinition stateDef, ParserContext parserContext, boolean abandon) {
        BeanDefinition endState = null;
        if (status.isEnd()) {
            BeanDefinitionBuilder endBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.state.EndState");
            boolean exitCodeExists = StringUtils.hasText((String)exitCode);
            endBuilder.addConstructorArgValue((Object)status);
            endBuilder.addConstructorArgValue((Object)(exitCodeExists ? exitCode : status.getName()));
            String endName = (status == FlowExecutionStatus.STOPPED ? STOP_ELE : (status == FlowExecutionStatus.FAILED ? FAIL_ELE : END_ELE)) + endCounter++;
            endBuilder.addConstructorArgValue((Object)endName);
            endBuilder.addConstructorArgValue((Object)abandon);
            String nextOnEnd = exitCodeExists ? null : next;
            endState = AbstractFlowParser.getStateTransitionReference(parserContext, (BeanDefinition)endBuilder.getBeanDefinition(), null, nextOnEnd);
            next = endName;
        }
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        list.add(AbstractFlowParser.getStateTransitionReference(parserContext, stateDef, on, (String)next));
        if (endState != null) {
            list.add(endState);
        }
        return list;
    }

    protected static FlowExecutionStatus getBatchStatusFromEndTransitionName(String elementName) {
        return switch (elementName = AbstractFlowParser.stripNamespace(elementName)) {
            case STOP_ELE -> FlowExecutionStatus.STOPPED;
            case END_ELE -> FlowExecutionStatus.COMPLETED;
            case FAIL_ELE -> FlowExecutionStatus.FAILED;
            default -> FlowExecutionStatus.UNKNOWN;
        };
    }

    private static String stripNamespace(String elementName) {
        if (elementName.startsWith("batch:")) {
            return elementName.substring(6);
        }
        return elementName;
    }

    public static BeanDefinition getStateTransitionReference(ParserContext parserContext, BeanDefinition stateDefinition, String on, String next) {
        BeanDefinitionBuilder nextBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.StateTransition");
        nextBuilder.addConstructorArgValue((Object)stateDefinition);
        if (StringUtils.hasText((String)on)) {
            nextBuilder.addConstructorArgValue((Object)on);
        }
        if (StringUtils.hasText((String)next)) {
            nextBuilder.setFactoryMethod("createStateTransition");
            nextBuilder.addConstructorArgValue((Object)next);
        } else {
            nextBuilder.setFactoryMethod("createEndStateTransition");
        }
        return nextBuilder.getBeanDefinition();
    }
}

