/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.Collection;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class MongoExecutionContextDao
implements ExecutionContextDao {
    private static final String STEP_EXECUTIONS_COLLECTION_NAME = "BATCH_STEP_EXECUTION";
    private static final String JOB_EXECUTIONS_COLLECTION_NAME = "BATCH_JOB_EXECUTION";
    private final MongoOperations mongoOperations;

    public MongoExecutionContextDao(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    @Override
    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        org.springframework.batch.core.repository.persistence.JobExecution execution = (org.springframework.batch.core.repository.persistence.JobExecution)this.mongoOperations.findById((Object)jobExecution.getId(), org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
        if (execution == null) {
            return new ExecutionContext();
        }
        return new ExecutionContext(execution.getExecutionContext().map());
    }

    @Override
    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        org.springframework.batch.core.repository.persistence.StepExecution execution = (org.springframework.batch.core.repository.persistence.StepExecution)this.mongoOperations.findById((Object)stepExecution.getId(), org.springframework.batch.core.repository.persistence.StepExecution.class, STEP_EXECUTIONS_COLLECTION_NAME);
        if (execution == null) {
            return new ExecutionContext();
        }
        return new ExecutionContext(execution.getExecutionContext().map());
    }

    @Override
    public void saveExecutionContext(JobExecution jobExecution) {
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)jobExecution.getId()));
        Update update = Update.update((String)"executionContext", (Object)new org.springframework.batch.core.repository.persistence.ExecutionContext(executionContext.toMap(), executionContext.isDirty()));
        this.mongoOperations.updateFirst(query, (UpdateDefinition)update, org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
    }

    @Override
    public void saveExecutionContext(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)stepExecution.getId()));
        Update update = Update.update((String)"executionContext", (Object)new org.springframework.batch.core.repository.persistence.ExecutionContext(executionContext.toMap(), executionContext.isDirty()));
        this.mongoOperations.updateFirst(query, (UpdateDefinition)update, org.springframework.batch.core.repository.persistence.StepExecution.class, STEP_EXECUTIONS_COLLECTION_NAME);
    }

    @Override
    public void saveExecutionContexts(Collection<StepExecution> stepExecutions) {
        for (StepExecution stepExecution : stepExecutions) {
            this.saveExecutionContext(stepExecution);
        }
    }

    @Override
    public void updateExecutionContext(JobExecution jobExecution) {
        this.saveExecutionContext(jobExecution);
    }

    @Override
    public void updateExecutionContext(StepExecution stepExecution) {
        this.saveExecutionContext(stepExecution);
    }
}

