/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.MongoSequenceIncrementer;
import org.springframework.batch.core.repository.persistence.converter.JobExecutionConverter;
import org.springframework.batch.core.repository.persistence.converter.JobInstanceConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MongoJobExecutionDao
implements JobExecutionDao {
    private static final String JOB_EXECUTIONS_COLLECTION_NAME = "BATCH_JOB_EXECUTION";
    private static final String JOB_EXECUTIONS_SEQUENCE_NAME = "BATCH_JOB_EXECUTION_SEQ";
    private static final String JOB_INSTANCES_COLLECTION_NAME = "BATCH_JOB_INSTANCE";
    private final MongoOperations mongoOperations;
    private final JobExecutionConverter jobExecutionConverter = new JobExecutionConverter();
    private final JobInstanceConverter jobInstanceConverter = new JobInstanceConverter();
    private DataFieldMaxValueIncrementer jobExecutionIncrementer;

    public MongoJobExecutionDao(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
        this.jobExecutionIncrementer = new MongoSequenceIncrementer(mongoOperations, JOB_EXECUTIONS_SEQUENCE_NAME);
    }

    public void setJobExecutionIncrementer(DataFieldMaxValueIncrementer jobExecutionIncrementer) {
        this.jobExecutionIncrementer = jobExecutionIncrementer;
    }

    @Override
    public void saveJobExecution(JobExecution jobExecution) {
        org.springframework.batch.core.repository.persistence.JobExecution jobExecutionToSave = this.jobExecutionConverter.fromJobExecution(jobExecution);
        long jobExecutionId = this.jobExecutionIncrementer.nextLongValue();
        jobExecutionToSave.setJobExecutionId(jobExecutionId);
        this.mongoOperations.insert((Object)jobExecutionToSave, JOB_EXECUTIONS_COLLECTION_NAME);
        jobExecution.setId(jobExecutionId);
    }

    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobExecutionId").is((Object)jobExecution.getId()));
        org.springframework.batch.core.repository.persistence.JobExecution jobExecutionToUpdate = this.jobExecutionConverter.fromJobExecution(jobExecution);
        this.mongoOperations.findAndReplace(query, (Object)jobExecutionToUpdate, JOB_EXECUTIONS_COLLECTION_NAME);
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobInstanceId").is((Object)jobInstance.getId()));
        List jobExecutions = this.mongoOperations.find(query, org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
        return jobExecutions.stream().map(jobExecution -> this.jobExecutionConverter.toJobExecution((org.springframework.batch.core.repository.persistence.JobExecution)jobExecution, jobInstance)).toList();
    }

    @Override
    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobInstanceId").is((Object)jobInstance.getId()));
        Sort.Order sortOrder = Sort.Order.desc((String)"jobExecutionId");
        org.springframework.batch.core.repository.persistence.JobExecution jobExecution = (org.springframework.batch.core.repository.persistence.JobExecution)this.mongoOperations.findOne(query.with(Sort.by((Sort.Order[])new Sort.Order[]{sortOrder})), org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
        return jobExecution != null ? this.jobExecutionConverter.toJobExecution(jobExecution, jobInstance) : null;
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobName").is((Object)jobName));
        List<JobInstance> jobInstances = this.mongoOperations.find(query, org.springframework.batch.core.repository.persistence.JobInstance.class, JOB_INSTANCES_COLLECTION_NAME).stream().map(this.jobInstanceConverter::toJobInstance).toList();
        HashSet<JobExecution> runningJobExecutions = new HashSet<JobExecution>();
        for (JobInstance jobInstance : jobInstances) {
            query = Query.query((CriteriaDefinition)Criteria.where((String)"jobInstanceId").is((Object)jobInstance.getId()).and("status").in(new Object[]{"STARTING", "STARTED", "STOPPING"}));
            this.mongoOperations.find(query, org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME).stream().map(jobExecution -> this.jobExecutionConverter.toJobExecution((org.springframework.batch.core.repository.persistence.JobExecution)jobExecution, jobInstance)).forEach(runningJobExecutions::add);
        }
        return runningJobExecutions;
    }

    @Override
    public JobExecution getJobExecution(Long executionId) {
        org.springframework.batch.core.repository.persistence.JobExecution jobExecution = (org.springframework.batch.core.repository.persistence.JobExecution)this.mongoOperations.findById((Object)executionId, org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
        if (jobExecution == null) {
            return null;
        }
        org.springframework.batch.core.repository.persistence.JobInstance jobInstance = (org.springframework.batch.core.repository.persistence.JobInstance)this.mongoOperations.findById((Object)jobExecution.getJobInstanceId(), org.springframework.batch.core.repository.persistence.JobInstance.class, JOB_INSTANCES_COLLECTION_NAME);
        return this.jobExecutionConverter.toJobExecution(jobExecution, this.jobInstanceConverter.toJobInstance(jobInstance));
    }

    @Override
    public void synchronizeStatus(JobExecution jobExecution) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobExecutionId").is((Object)jobExecution.getId()));
        Update update = Update.update((String)"status", (Object)((Object)jobExecution.getStatus()));
        this.mongoOperations.updateFirst(query, (UpdateDefinition)update, org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
    }
}

