/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support;

import java.util.Comparator;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.util.StringUtils;

public class DefaultStateTransitionComparator
implements Comparator<StateTransition> {
    public static final String STATE_TRANSITION_COMPARATOR = "batch_state_transition_comparator";

    @Override
    public int compare(StateTransition arg0, StateTransition arg1) {
        int arg1WildcardCount;
        int arg0WildcardCount;
        String arg0Pattern = arg0.getPattern();
        String arg1Pattern = arg1.getPattern();
        if (arg0.getPattern().equals(arg1Pattern)) {
            return 0;
        }
        int arg0AsteriskCount = StringUtils.countOccurrencesOf((String)arg0Pattern, (String)"*");
        int arg1AsteriskCount = StringUtils.countOccurrencesOf((String)arg1Pattern, (String)"*");
        if (arg0AsteriskCount > 0 && arg1AsteriskCount == 0) {
            return -1;
        }
        if (arg0AsteriskCount == 0 && arg1AsteriskCount > 0) {
            return 1;
        }
        if (arg0AsteriskCount > 0 && arg1AsteriskCount > 0) {
            if (arg0AsteriskCount < arg1AsteriskCount) {
                return -1;
            }
            if (arg0AsteriskCount > arg1AsteriskCount) {
                return 1;
            }
        }
        if ((arg0WildcardCount = StringUtils.countOccurrencesOf((String)arg0Pattern, (String)"?")) > (arg1WildcardCount = StringUtils.countOccurrencesOf((String)arg1Pattern, (String)"?"))) {
            return -1;
        }
        if (arg0WildcardCount < arg1WildcardCount) {
            return 1;
        }
        if (arg0Pattern.length() != arg1Pattern.length() && (arg0AsteriskCount > 0 || arg0WildcardCount > 0)) {
            return Integer.compare(arg0Pattern.length(), arg1Pattern.length());
        }
        return arg1.getPattern().compareTo(arg0Pattern);
    }
}

