/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.listener.OrderedComposite;
import org.springframework.batch.core.scope.context.ChunkContext;

public class CompositeChunkListener
implements ChunkListener {
    private final OrderedComposite<ChunkListener> listeners = new OrderedComposite();

    public CompositeChunkListener() {
    }

    public CompositeChunkListener(List<? extends ChunkListener> listeners) {
        this.setListeners(listeners);
    }

    public CompositeChunkListener(ChunkListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public void setListeners(List<? extends ChunkListener> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(ChunkListener chunkListener) {
        this.listeners.add(chunkListener);
    }

    @Override
    public void afterChunk(ChunkContext context) {
        Iterator<ChunkListener> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ChunkListener listener = iterator.next();
            listener.afterChunk(context);
        }
    }

    @Override
    public void beforeChunk(ChunkContext context) {
        Iterator<ChunkListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChunkListener listener = iterator.next();
            listener.beforeChunk(context);
        }
    }

    @Override
    public void afterChunkError(ChunkContext context) {
        Iterator<ChunkListener> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ChunkListener listener = iterator.next();
            listener.afterChunkError(context);
        }
    }
}

