/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.listener.StepListenerFailedException;
import org.springframework.batch.core.observability.BatchMetrics;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.ForceRollbackForWriteSkipException;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableProcessException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.SkipWrapper;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;
import org.springframework.retry.ExhaustedRetryException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryException;
import org.springframework.retry.RetryState;
import org.springframework.retry.support.DefaultRetryState;

public class FaultTolerantChunkProcessor<I, O>
extends SimpleChunkProcessor<I, O> {
    private SkipPolicy itemProcessSkipPolicy = new LimitCheckingItemSkipPolicy();
    private SkipPolicy itemWriteSkipPolicy = new LimitCheckingItemSkipPolicy();
    private final BatchRetryTemplate batchRetryTemplate;
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean buffering = true;
    private KeyGenerator keyGenerator;
    private ChunkMonitor chunkMonitor = new ChunkMonitor();
    private boolean processorTransactional = true;

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setProcessSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemProcessSkipPolicy = SkipPolicy2;
    }

    public void setWriteSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemWriteSkipPolicy = SkipPolicy2;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    public void setChunkMonitor(ChunkMonitor chunkMonitor) {
        this.chunkMonitor = chunkMonitor;
    }

    public void setBuffering(boolean buffering) {
        this.buffering = buffering;
    }

    public void setProcessorTransactional(boolean processorTransactional) {
        this.processorTransactional = processorTransactional;
    }

    public FaultTolerantChunkProcessor(ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, BatchRetryTemplate batchRetryTemplate) {
        super(itemProcessor, itemWriter);
        this.batchRetryTemplate = batchRetryTemplate;
    }

    @Override
    protected void initializeUserData(Chunk<I> inputs) {
        UserData data = (UserData)inputs.getUserData();
        if (data == null) {
            data = new UserData();
            inputs.setUserData(data);
            data.setOutputs(new Chunk(new Object[0]));
        } else if (data.scanning()) {
            data.filterCount = 0;
        }
    }

    @Override
    protected int getFilterCount(Chunk<I> inputs, Chunk<O> outputs) {
        UserData data = (UserData)inputs.getUserData();
        return data.filterCount;
    }

    @Override
    protected boolean isComplete(Chunk<I> inputs) {
        UserData data = (UserData)inputs.getUserData();
        Chunk previous = data.getOutputs();
        return inputs.isEmpty() && previous.getSkips().isEmpty();
    }

    @Override
    protected Chunk<O> getAdjustedOutputs(Chunk<I> inputs, Chunk<O> outputs) {
        UserData data = (UserData)inputs.getUserData();
        Chunk previous = data.getOutputs();
        Chunk next = new Chunk(outputs.getItems(), previous.getSkips());
        next.setBusy(previous.isBusy());
        data.setOutputs(next);
        return next;
    }

    @Override
    protected Chunk<O> transform(StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk outputs = new Chunk(new Object[0]);
        UserData data = (UserData)inputs.getUserData();
        Chunk cache = data.getOutputs();
        Iterator cacheIterator = cache.isEmpty() ? null : new ArrayList(cache.getItems()).iterator();
        Chunk.ChunkIterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            RecoveryCallback recoveryCallback;
            Object item = iterator.next();
            RetryCallback retryCallback = context -> {
                Object output;
                block13: {
                    Timer.Sample sample = BatchMetrics.createTimerSample(this.meterRegistry);
                    String status = "SUCCESS";
                    output = null;
                    try {
                        Object cached;
                        Object v0 = cached = cacheIterator != null && cacheIterator.hasNext() ? cacheIterator.next() : null;
                        if (cached != null && !this.processorTransactional) {
                            output = cached;
                        } else {
                            output = this.doProcess(item);
                            if (output == null) {
                                data.incrementFilterCount();
                            } else if (!this.processorTransactional && !data.scanning()) {
                                cache.add(output);
                            }
                        }
                    }
                    catch (Exception e) {
                        status = "FAILURE";
                        if (((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                            throw e;
                        }
                        if (this.shouldSkip(this.itemProcessSkipPolicy, e, contribution.getStepSkipCount())) {
                            contribution.incrementProcessSkipCount();
                            this.logger.debug((Object)"Skipping after failed process with no rollback", (Throwable)e);
                            this.callProcessSkipListener(item, e);
                            break block13;
                        }
                        throw new NonSkippableProcessException("Non-skippable exception in processor.  Make sure any exceptions that do not cause a rollback are skippable.", e);
                    }
                    finally {
                        this.stopTimer(sample, contribution.getStepExecution(), "item.process", status, "Item processing");
                    }
                }
                if (output == null) {
                    iterator.remove();
                }
                return output;
            };
            Object output = this.batchRetryTemplate.execute(retryCallback, recoveryCallback = context -> {
                Throwable e = context.getLastThrowable();
                if (this.shouldSkip(this.itemProcessSkipPolicy, e, contribution.getStepSkipCount())) {
                    iterator.remove(e);
                    contribution.incrementProcessSkipCount();
                    this.logger.debug((Object)"Skipping after failed process", e);
                    return null;
                }
                if (((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                    throw new RetryException("Non-skippable exception in recoverer while processing", e);
                }
                iterator.remove(e);
                return null;
            }, (RetryState)new DefaultRetryState(this.getInputKey(item), this.rollbackClassifier));
            if (output != null) {
                outputs.add(output);
            }
            if (!data.scanning()) continue;
            while (cacheIterator != null && cacheIterator.hasNext()) {
                outputs.add(cacheIterator.next());
            }
            break block0;
        }
        if (inputs.isEnd()) {
            outputs.setEnd();
        }
        return outputs;
    }

    @Override
    protected void write(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs) throws Exception {
        UserData data = (UserData)inputs.getUserData();
        AtomicReference contextHolder = new AtomicReference();
        RetryCallback retryCallback = context -> {
            contextHolder.set(context);
            if (!data.scanning()) {
                this.chunkMonitor.setChunkSize(inputs.size());
                Timer.Sample sample = BatchMetrics.createTimerSample(this.meterRegistry);
                String status = "SUCCESS";
                try {
                    this.doWrite(outputs);
                }
                catch (Exception e) {
                    status = "FAILURE";
                    if (((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                        throw e;
                    }
                    throw new ForceRollbackForWriteSkipException("Force rollback on skippable exception so that skipped item can be located.", e);
                }
                finally {
                    this.stopTimer(sample, contribution.getStepExecution(), "chunk.write", status, "Chunk writing");
                }
                contribution.incrementWriteCount(outputs.size());
            } else {
                this.scan(contribution, inputs, outputs, this.chunkMonitor, false);
            }
            return null;
        };
        if (!this.buffering) {
            RecoveryCallback batchRecoveryCallback = context -> {
                Throwable e = context.getLastThrowable();
                if (outputs.size() > 1 && !((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                    throw new RetryException("Invalid retry state during write caused by exception that does not classify for rollback: ", e);
                }
                Chunk.ChunkIterator inputIterator = inputs.iterator();
                Chunk.ChunkIterator outputIterator = outputs.iterator();
                while (outputIterator.hasNext()) {
                    inputIterator.next();
                    outputIterator.next();
                    this.checkSkipPolicy(inputIterator, outputIterator, e, contribution, true);
                    if (((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) continue;
                    throw new RetryException("Invalid retry state during recovery caused by exception that does not classify for rollback: ", e);
                }
                return null;
            };
            this.batchRetryTemplate.execute(retryCallback, batchRecoveryCallback, BatchRetryTemplate.createState(this.getInputKeys(inputs), this.rollbackClassifier));
        } else {
            RecoveryCallback recoveryCallback = context -> {
                if (!this.shouldSkip(this.itemWriteSkipPolicy, context.getLastThrowable(), -1L)) {
                    throw new ExhaustedRetryException("Retry exhausted after last attempt in recovery path, but exception is not skippable.", context.getLastThrowable());
                }
                inputs.setBusy(true);
                data.scanning(true);
                this.scan(contribution, inputs, outputs, this.chunkMonitor, true);
                return null;
            };
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempting to write: " + inputs));
            }
            try {
                this.batchRetryTemplate.execute(retryCallback, recoveryCallback, (RetryState)new DefaultRetryState(inputs, this.rollbackClassifier));
            }
            catch (Exception e) {
                RetryContext context2 = (RetryContext)contextHolder.get();
                if (!this.batchRetryTemplate.canRetry(context2)) {
                    data.scanning(true);
                }
                throw e;
            }
        }
        this.callSkipListeners(inputs, outputs);
    }

    private void callSkipListeners(Chunk<I> inputs, Chunk<O> outputs) {
        for (SkipWrapper wrapper : inputs.getSkips()) {
            Object item = wrapper.getItem();
            if (item == null) continue;
            Throwable e = wrapper.getException();
            this.callProcessSkipListener(item, e);
        }
        for (SkipWrapper wrapper : outputs.getSkips()) {
            Throwable e = wrapper.getException();
            try {
                this.getListener().onSkipInWrite(wrapper.getItem(), e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
        outputs.clearSkips();
        inputs.clearSkips();
    }

    private void callProcessSkipListener(I item, Throwable e) {
        try {
            this.getListener().onSkipInProcess(item, e);
        }
        catch (RuntimeException ex) {
            throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
        }
    }

    private boolean shouldSkip(SkipPolicy policy, Throwable e, long skipCount) {
        try {
            return policy.shouldSkip(e, skipCount);
        }
        catch (SkipLimitExceededException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SkipListenerFailedException("Fatal exception in SkipPolicy.", ex, e);
        }
    }

    private Object getInputKey(I item) {
        if (this.keyGenerator == null) {
            return item;
        }
        return this.keyGenerator.getKey(item);
    }

    private List<?> getInputKeys(Chunk<I> inputs) {
        if (this.keyGenerator == null) {
            return inputs.getItems();
        }
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Object item : inputs.getItems()) {
            keys.add(this.keyGenerator.getKey(item));
        }
        return keys;
    }

    private void checkSkipPolicy(Chunk.ChunkIterator inputIterator, Chunk.ChunkIterator outputIterator, Throwable e, StepContribution contribution, boolean recovery) throws Exception {
        this.logger.debug((Object)"Checking skip policy after failed write");
        if (!this.shouldSkip(this.itemWriteSkipPolicy, e, contribution.getStepSkipCount())) {
            if (recovery) {
                throw new RetryException("Non-skippable exception in recoverer", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RetryException("Non-skippable throwable in recoverer", e);
        }
        contribution.incrementWriteSkipCount();
        inputIterator.remove();
        outputIterator.remove(e);
        this.logger.debug((Object)"Skipping after failed write", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs, ChunkMonitor chunkMonitor, boolean recovery) throws Exception {
        UserData data;
        block14: {
            data = (UserData)inputs.getUserData();
            if (this.logger.isDebugEnabled()) {
                if (recovery) {
                    this.logger.debug((Object)("Scanning for failed item on recovery from write: " + inputs));
                } else {
                    this.logger.debug((Object)("Scanning for failed item on write: " + inputs));
                }
            }
            if (outputs.isEmpty() || inputs.isEmpty()) {
                data.scanning(false);
                inputs.setBusy(false);
                chunkMonitor.resetOffset();
                return;
            }
            Chunk.ChunkIterator inputIterator = inputs.iterator();
            Chunk.ChunkIterator outputIterator = outputs.iterator();
            if (!inputs.getSkips().isEmpty() && inputs.getItems().size() != outputs.getItems().size() && outputIterator.hasNext()) {
                outputIterator.remove();
                return;
            }
            Chunk items = Chunk.of((Object[])new Object[]{outputIterator.next()});
            inputIterator.next();
            try {
                this.writeItems(items);
                this.doAfterWrite(items);
                contribution.incrementWriteCount(1L);
                inputIterator.remove();
                outputIterator.remove();
            }
            catch (Exception e) {
                try {
                    this.doOnWriteError(e, items);
                }
                finally {
                    Throwable cause = e;
                    if (e instanceof StepListenerFailedException) {
                        cause = e.getCause();
                    }
                    if (!this.shouldSkip(this.itemWriteSkipPolicy, cause, -1L) && !((Boolean)this.rollbackClassifier.classify((Object)cause)).booleanValue()) {
                        inputIterator.remove();
                        outputIterator.remove();
                    } else {
                        this.checkSkipPolicy(inputIterator, outputIterator, cause, contribution, recovery);
                    }
                    if (!((Boolean)this.rollbackClassifier.classify((Object)cause)).booleanValue()) break block14;
                    throw cause;
                }
            }
        }
        chunkMonitor.incrementOffset();
        if (outputs.isEmpty()) {
            data.scanning(false);
            inputs.setBusy(false);
            chunkMonitor.resetOffset();
        }
    }

    private static class UserData<O> {
        private Chunk<O> outputs;
        private int filterCount = 0;
        private boolean scanning;

        private UserData() {
        }

        public boolean scanning() {
            return this.scanning;
        }

        public void scanning(boolean scanning) {
            this.scanning = scanning;
        }

        public void incrementFilterCount() {
            ++this.filterCount;
        }

        public Chunk<O> getOutputs() {
            return this.outputs;
        }

        public void setOutputs(Chunk<O> outputs) {
            this.outputs = outputs;
        }
    }
}

