/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.database.AbstractTransactionalResourceItemWriter;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.util.Assert;

public class BatchSqlUpdateItemWriter
extends AbstractTransactionalResourceItemWriter
implements InitializingBean {
    private static final String ITEMS_PROCESSED = BatchSqlUpdateItemWriter.class.getName() + ".ITEMS_PROCESSED";
    private JdbcOperations jdbcTemplate;
    private ItemPreparedStatementSetter preparedStatementSetter;
    private String sql;
    private boolean assertUpdates = true;

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setItemPreparedStatementSetter(ItemPreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jdbcTemplate, (String)"BatchSqlUpdateItemWriter requires an data source.");
        Assert.notNull((Object)this.preparedStatementSetter, (String)"BatchSqlUpdateItemWriter requires a ItemPreparedStatementSetter");
    }

    protected void doFlush() throws EmptyResultDataAccessException {
        final ArrayList processed = new ArrayList(this.getProcessed());
        if (!processed.isEmpty()) {
            int[] values = (int[])this.jdbcTemplate.execute(this.sql, new PreparedStatementCallback(){

                public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                    Iterator iterator = processed.iterator();
                    while (iterator.hasNext()) {
                        Object item = iterator.next();
                        BatchSqlUpdateItemWriter.this.preparedStatementSetter.setValues(item, ps);
                        ps.addBatch();
                    }
                    return ps.executeBatch();
                }
            });
            if (this.assertUpdates) {
                for (int i = 0; i < values.length; ++i) {
                    int value = values[i];
                    if (value != 0) continue;
                    throw new EmptyResultDataAccessException("Item " + i + " of " + values.length + " did not update any rows: [" + processed.get(i) + "]", 1);
                }
            }
        }
    }

    protected String getResourceKey() {
        return ITEMS_PROCESSED;
    }

    protected void doWrite(Object output) {
    }

    protected void doClear() throws ClearFailedException {
    }
}

