/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import javax.sql.DataSource;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DB2SequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DerbyMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.HsqlMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgreSQLSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.SqlServerMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.SybaseMaxValueIncrementer;

public class DefaultDataFieldMaxValueIncrementerFactory
implements DataFieldMaxValueIncrementerFactory {
    static final String DB_TYPE_DB2 = "db2";
    static final String DB_TYPE_DERBY = "derby";
    static final String DB_TYPE_HSQL = "hsql";
    static final String DB_TYPE_MYSQL = "mysql";
    static final String DB_TYPE_ORACLE = "oracle";
    static final String DB_TYPE_POSTGRES = "postgres";
    static final String DB_TYPE_SQLSERVER = "sqlserver";
    static final String DB_TYPE_SYBASE = "sybase";
    private DataSource dataSource;
    private String incrementerColumnName = "ID";

    public void setIncrementerColumnName(String incrementerColumnName) {
        this.incrementerColumnName = incrementerColumnName;
    }

    public DefaultDataFieldMaxValueIncrementerFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataFieldMaxValueIncrementer getIncrementer(String incrementerType, String incrementerName) {
        if (DB_TYPE_DB2.equals(incrementerType)) {
            return new DB2SequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (DB_TYPE_DERBY.equals(incrementerType)) {
            return new DerbyMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (DB_TYPE_HSQL.equals(incrementerType)) {
            return new HsqlMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (DB_TYPE_MYSQL.equals(incrementerType)) {
            return new MySQLMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (DB_TYPE_ORACLE.equals(incrementerType)) {
            return new OracleSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (DB_TYPE_POSTGRES.equals(incrementerType)) {
            return new PostgreSQLSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (DB_TYPE_SQLSERVER.equals(incrementerType)) {
            return new SqlServerMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (DB_TYPE_SYBASE.equals(incrementerType)) {
            return new SybaseMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        throw new IllegalArgumentException("databaseType argument was not on the approved list");
    }

    public boolean isSupportedIncrementerType(String incrementerType) {
        return DB_TYPE_DB2.equals(incrementerType) || DB_TYPE_DERBY.equals(incrementerType) || DB_TYPE_HSQL.equals(incrementerType) || DB_TYPE_MYSQL.equals(incrementerType) || DB_TYPE_ORACLE.equals(incrementerType) || DB_TYPE_POSTGRES.equals(incrementerType) || DB_TYPE_SQLSERVER.equals(incrementerType) || DB_TYPE_SYBASE.equals(incrementerType);
    }

    public String[] getSupportedIncrementerTypes() {
        return new String[]{DB_TYPE_DB2, DB_TYPE_DERBY, DB_TYPE_HSQL, DB_TYPE_MYSQL, DB_TYPE_ORACLE, DB_TYPE_POSTGRES, DB_TYPE_SQLSERVER, DB_TYPE_SYBASE};
    }
}

