/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.context;

import org.springframework.batch.repeat.context.AtomicCounter;
import org.springframework.batch.repeat.context.BackportConcurrentAtomicCounter;
import org.springframework.batch.repeat.context.JdkConcurrentAtomicCounter;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;

class AtomicCounterFactory {
    private static final boolean backportConcurrentAvailable = ClassUtils.isPresent((String)"edu.emory.mathcs.backport.java.util.concurrent.Semaphore", (ClassLoader)AtomicCounterFactory.class.getClassLoader());
    private final AtomicCounter counter;

    public AtomicCounterFactory() {
        if (JdkVersion.isAtLeastJava15()) {
            this.counter = new JdkConcurrentAtomicCounter();
        } else if (backportConcurrentAvailable) {
            this.counter = new BackportConcurrentAtomicCounter();
        } else {
            throw new IllegalStateException("Cannot create AtomicCounter - neither JDK 1.5 nor backport-concurrent available on the classpath");
        }
    }

    public AtomicCounter getAtomicCounter() {
        return this.counter;
    }
}

