/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.exception;

import java.util.HashMap;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.exception.RethrowOnThresholdExceptionHandler;
import org.springframework.batch.support.ExceptionClassifierSupport;

public class SimpleLimitExceptionHandler
implements ExceptionHandler {
    private static final String TX_INVALID = "TX_INVALID";
    private static final String FATAL = "FATAL";
    private RethrowOnThresholdExceptionHandler delegate = new RethrowOnThresholdExceptionHandler();
    private Class[] exceptionClasses = new Class[]{Exception.class};
    private Class[] fatalExceptionClasses = new Class[]{Error.class};

    public void setUseParent(boolean useParent) {
        this.delegate.setUseParent(useParent);
    }

    public SimpleLimitExceptionHandler(int limit) {
        this();
        this.setLimit(limit);
    }

    public SimpleLimitExceptionHandler() {
        this.delegate.setExceptionClassifier(new ExceptionClassifierSupport(){

            public Object classify(Throwable throwable) {
                int i;
                for (i = 0; i < SimpleLimitExceptionHandler.this.fatalExceptionClasses.length; ++i) {
                    if (!SimpleLimitExceptionHandler.this.fatalExceptionClasses[i].isAssignableFrom(throwable.getClass())) continue;
                    return SimpleLimitExceptionHandler.FATAL;
                }
                for (i = 0; i < SimpleLimitExceptionHandler.this.exceptionClasses.length; ++i) {
                    if (!SimpleLimitExceptionHandler.this.exceptionClasses[i].isAssignableFrom(throwable.getClass())) continue;
                    return SimpleLimitExceptionHandler.TX_INVALID;
                }
                return super.classify(throwable);
            }
        });
    }

    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        this.delegate.handleException(context, throwable);
    }

    public void setLimit(final int limit) {
        this.delegate.setThresholds(new HashMap(){
            {
                this.put("default", new Integer(0));
                this.put(SimpleLimitExceptionHandler.TX_INVALID, new Integer(limit));
                this.put(SimpleLimitExceptionHandler.FATAL, new Integer(0));
            }
        });
    }

    public void setExceptionClasses(Class[] classes) {
        this.exceptionClasses = classes;
    }

    public void setFatalExceptionClasses(Class[] fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }
}

