/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.springframework.batch.item.xml.stax.AbstractEventReaderWrapper;
import org.springframework.batch.item.xml.stax.EventSequence;
import org.springframework.batch.item.xml.stax.TransactionalEventReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultTransactionalEventReader
extends AbstractEventReaderWrapper
implements TransactionalEventReader,
InitializingBean {
    private EventSequence recorder = new EventSequence();

    public DefaultTransactionalEventReader(XMLEventReader wrappedReader) {
        super(wrappedReader);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.wrappedEventReader);
    }

    public void onRollback() {
        this.recorder.reset();
    }

    public void onCommit() {
        this.recorder.clear();
    }

    public boolean hasNext() {
        return this.recorder.hasNext() || this.wrappedEventReader.hasNext();
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (!this.recorder.hasNext()) {
            this.recorder.addEvent(this.wrappedEventReader.nextEvent());
        }
        return this.recorder.nextEvent();
    }

    public XMLEvent peek() throws XMLStreamException {
        return this.recorder.hasNext() ? this.recorder.peek() : this.wrappedEventReader.peek();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

