/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.exception;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.RepeatContextCounter;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.support.ExceptionClassifier;
import org.springframework.batch.support.ExceptionClassifierSupport;
import org.springframework.util.Assert;

public class RethrowOnThresholdExceptionHandler
implements ExceptionHandler {
    protected final Log logger = LogFactory.getLog((Class)RethrowOnThresholdExceptionHandler.class);
    private ExceptionClassifier exceptionClassifier = new ExceptionClassifierSupport();
    private Map thresholds = new HashMap();
    private boolean useParent = false;

    public void setUseParent(boolean useParent) {
        this.useParent = useParent;
    }

    public RethrowOnThresholdExceptionHandler() {
        this.thresholds.put("default", new Integer(0));
    }

    public void setThresholds(Map thresholds) {
        Iterator iter = thresholds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof String)) {
                this.logger.warn((Object)("Key in thresholds map is not of type String: " + entry.getKey()));
            }
            Assert.state((boolean)(entry.getValue() instanceof Integer), (String)"Threshold value must be of type Integer.  Try using the value-type attribute if you care configuring this map via xml.");
        }
        this.thresholds = thresholds;
    }

    public void setExceptionClassifier(ExceptionClassifier exceptionClassifier) {
        this.exceptionClassifier = exceptionClassifier;
    }

    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        Object key = this.exceptionClassifier.classify(throwable);
        RepeatContextCounter counter = this.getCounter(context, key);
        counter.increment();
        int count = counter.getCount();
        Integer threshold = (Integer)this.thresholds.get(key);
        if (threshold == null || count > threshold) {
            throw throwable;
        }
    }

    private RepeatContextCounter getCounter(RepeatContext context, Object key) {
        String attribute = RethrowOnThresholdExceptionHandler.class.getName() + "." + key.toString();
        return new RepeatContextCounter(context, attribute, this.useParent);
    }
}

