/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.policy;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.RepeatContextSupport;

public class CompositeCompletionPolicy
implements CompletionPolicy {
    CompletionPolicy[] policies = new CompletionPolicy[0];

    public void setPolicies(CompletionPolicy[] policies) {
        this.policies = policies;
    }

    public boolean isComplete(RepeatContext context, ExitStatus result) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i = 0; i < policies.length; ++i) {
            if (!policies[i].isComplete(contexts[i], result)) continue;
            return true;
        }
        return false;
    }

    public boolean isComplete(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i = 0; i < policies.length; ++i) {
            if (!policies[i].isComplete(contexts[i])) continue;
            return true;
        }
        return false;
    }

    public RepeatContext start(RepeatContext context) {
        ArrayList<RepeatContext> list = new ArrayList<RepeatContext>();
        for (int i = 0; i < this.policies.length; ++i) {
            list.add(this.policies[i].start(context));
        }
        return new CompositeBatchContext(context, list);
    }

    public void update(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i = 0; i < policies.length; ++i) {
            policies[i].update(contexts[i]);
        }
        ((RepeatContextSupport)context).increment();
    }

    protected class CompositeBatchContext
    extends RepeatContextSupport {
        private RepeatContext[] contexts;
        private CompletionPolicy[] policies;

        public CompositeBatchContext(RepeatContext context, List contexts) {
            super(context);
            this.contexts = contexts.toArray(new RepeatContext[contexts.size()]);
            this.policies = CompositeCompletionPolicy.this.policies;
        }
    }
}

