/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiResourceItemReader<T>
implements ItemReader<T>,
ItemStream {
    private static final Log logger = LogFactory.getLog(MultiResourceItemReader.class);
    private final ExecutionContextUserSupport executionContextUserSupport = new ExecutionContextUserSupport();
    private ResourceAwareItemReaderItemStream<? extends T> delegate;
    private Resource[] resources;
    private MultiResourceIndex index = new MultiResourceIndex();
    private boolean saveState = true;
    private boolean noInput;
    private Comparator<Resource> comparator = new Comparator<Resource>(){

        @Override
        public int compare(Resource r1, Resource r2) {
            return r1.getFilename().compareTo(r2.getFilename());
        }
    };

    public MultiResourceItemReader() {
        this.executionContextUserSupport.setName(ClassUtils.getShortName(MultiResourceItemReader.class));
    }

    @Override
    public T read() throws Exception, UnexpectedInputException, ParseException {
        if (this.noInput) {
            return null;
        }
        T item = this.readNextItem();
        this.index.incrementItemCount();
        return item;
    }

    private T readNextItem() throws Exception {
        Object item = this.delegate.read();
        while (item == null) {
            this.index.incrementResourceCount();
            if (this.index.currentResource >= this.resources.length) {
                return null;
            }
            this.delegate.close();
            this.delegate.setResource(this.resources[this.index.currentResource]);
            this.delegate.open(new ExecutionContext());
            item = this.delegate.read();
        }
        return item;
    }

    @Override
    public void close() throws ItemStreamException {
        this.index = new MultiResourceIndex();
        this.delegate.close();
        this.noInput = false;
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        Assert.notNull((Object)this.resources, (String)"Resources must be set");
        this.noInput = false;
        if (this.resources.length == 0) {
            logger.warn((Object)"No resources to read");
            this.noInput = true;
            return;
        }
        Arrays.sort(this.resources, this.comparator);
        this.index.open(executionContext);
        this.delegate.setResource(this.resources[this.index.currentResource]);
        this.delegate.open(new ExecutionContext());
        try {
            int i = 0;
            while (i < this.index.currentItem) {
                this.delegate.read();
                ++i;
            }
        }
        catch (Exception e) {
            throw new ItemStreamException("Could not restore position on restart", e);
        }
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.saveState) {
            this.index.update(executionContext);
        }
    }

    public void setDelegate(ResourceAwareItemReaderItemStream<? extends T> delegate) {
        this.delegate = delegate;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void setComparator(Comparator<Resource> comparator) {
        this.comparator = comparator;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }

    public Resource getCurrentResource() {
        if (this.index.currentResource >= this.resources.length) {
            return null;
        }
        return this.resources[this.index.currentResource];
    }

    private class MultiResourceIndex {
        private static final String RESOURCE_KEY = "resourceIndex";
        private static final String ITEM_KEY = "itemIndex";
        private int currentResource = 0;
        private int markedResource = 0;
        private int currentItem = 0;
        private int markedItem = 0;

        private MultiResourceIndex() {
        }

        public void incrementItemCount() {
            ++this.currentItem;
        }

        public void incrementResourceCount() {
            ++this.currentResource;
            this.currentItem = 0;
        }

        public void mark() {
            this.markedResource = this.currentResource;
            this.markedItem = this.currentItem;
        }

        public void reset() {
            this.currentResource = this.markedResource;
            this.currentItem = this.markedItem;
        }

        public void open(ExecutionContext ctx) {
            if (ctx.containsKey(MultiResourceItemReader.this.executionContextUserSupport.getKey(RESOURCE_KEY))) {
                this.currentResource = ctx.getInt(MultiResourceItemReader.this.executionContextUserSupport.getKey(RESOURCE_KEY));
            }
            if (ctx.containsKey(MultiResourceItemReader.this.executionContextUserSupport.getKey(ITEM_KEY))) {
                this.currentItem = ctx.getInt(MultiResourceItemReader.this.executionContextUserSupport.getKey(ITEM_KEY));
            }
        }

        public void update(ExecutionContext ctx) {
            ctx.putInt(MultiResourceItemReader.this.executionContextUserSupport.getKey(RESOURCE_KEY), ((MultiResourceItemReader)MultiResourceItemReader.this).index.currentResource);
            ctx.putInt(MultiResourceItemReader.this.executionContextUserSupport.getKey(ITEM_KEY), ((MultiResourceItemReader)MultiResourceItemReader.this).index.currentItem);
        }
    }
}

