/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;

public class CompositeItemStream
implements ItemStream {
    private List<ItemStream> streams = new ArrayList<ItemStream>();

    public void setStreams(ItemStream[] listeners) {
        this.streams = Arrays.asList(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ItemStream stream) {
        List<ItemStream> list = this.streams;
        synchronized (list) {
            if (!this.streams.contains(stream)) {
                this.streams.add(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ExecutionContext executionContext) {
        List<ItemStream> list = this.streams;
        synchronized (list) {
            for (ItemStream itemStream : this.streams) {
                itemStream.update(executionContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ItemStreamException {
        List<ItemStream> list = this.streams;
        synchronized (list) {
            for (ItemStream itemStream : this.streams) {
                itemStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        List<ItemStream> list = this.streams;
        synchronized (list) {
            for (ItemStream itemStream : this.streams) {
                itemStream.open(executionContext);
            }
        }
    }
}

