/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.Map;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.PeekableItemReader;
import org.springframework.batch.item.UnexpectedInputException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleItemPeekableItemReader<T>
implements ItemStreamReader<T>,
PeekableItemReader<T> {
    private ItemReader<T> delegate;
    private T next;
    private ExecutionContext executionContext = new ExecutionContext();

    public void setDelegate(ItemReader<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T read() throws Exception, UnexpectedInputException, ParseException {
        if (this.next != null) {
            T item = this.next;
            this.next = null;
            return item;
        }
        return this.delegate.read();
    }

    @Override
    public T peek() throws Exception, UnexpectedInputException, ParseException {
        if (this.next == null) {
            this.updateDelegate(this.executionContext);
            this.next = this.delegate.read();
        }
        return this.next;
    }

    @Override
    public void close() throws ItemStreamException {
        this.next = null;
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)((Object)this.delegate)).close();
        }
        this.executionContext = new ExecutionContext();
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.next = null;
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)((Object)this.delegate)).open(executionContext);
        }
        executionContext = new ExecutionContext();
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.next != null) {
            for (Map.Entry<String, Object> entry : this.executionContext.entrySet()) {
                executionContext.put(entry.getKey(), entry.getValue());
            }
            return;
        }
        this.updateDelegate(executionContext);
    }

    private void updateDelegate(ExecutionContext executionContext) {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)((Object)this.delegate)).update(executionContext);
        }
    }
}

