/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.hibernate3.HibernateOperations;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(HibernateItemWriter.class);
    private HibernateOperations hibernateTemplate;

    public void setHibernateTemplate(HibernateOperations hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.hibernateTemplate, (String)"HibernateItemWriter requires a HibernateOperations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(List<? extends T> items) {
        this.doWrite(this.hibernateTemplate, items);
        try {
            this.hibernateTemplate.flush();
        }
        finally {
            this.hibernateTemplate.clear();
        }
    }

    protected void doWrite(HibernateOperations hibernateTemplate, List<? extends T> items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing to Hibernate with " + items.size() + " items."));
        }
        if (!items.isEmpty()) {
            long saveOrUpdateCount = 0L;
            for (T item : items) {
                if (hibernateTemplate.contains(item)) continue;
                hibernateTemplate.saveOrUpdate(item);
                ++saveOrUpdateCount;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(saveOrUpdateCount + " entities saved/updated."));
                logger.debug((Object)((long)items.size() - saveOrUpdateCount + " entities found in session."));
            }
        }
    }
}

