/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.poller;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.batch.poller.Poller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectPoller<S>
implements Poller<S> {
    private final long interval;

    public DirectPoller(long interval) {
        this.interval = interval;
    }

    @Override
    public Future<S> poll(Callable<S> callable) throws Exception {
        return new DirectPollingFuture<S>(this.interval, callable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectPollingFuture<S>
    implements Future<S> {
        private final long startTime = System.currentTimeMillis();
        private volatile boolean cancelled;
        private volatile S result = null;
        private final long interval;
        private final Callable<S> callable;

        public DirectPollingFuture(long interval, Callable<S> callable) {
            this.interval = interval;
            this.callable = callable;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return true;
        }

        @Override
        public S get() throws InterruptedException, ExecutionException {
            try {
                return this.get(-1L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Unexpected timeout waiting for result", e);
            }
        }

        @Override
        public S get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                this.result = this.callable.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            Long nextExecutionTime = this.startTime + this.interval;
            long currentTimeMillis = System.currentTimeMillis();
            long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
            while (this.result == null && !this.cancelled) {
                long delta = nextExecutionTime - this.startTime;
                if (delta >= timeoutMillis && timeoutMillis > 0L) {
                    throw new TimeoutException("Timed out waiting for task to return non-null result");
                }
                if (nextExecutionTime > currentTimeMillis) {
                    Thread.sleep(nextExecutionTime - currentTimeMillis);
                }
                currentTimeMillis = System.currentTimeMillis();
                nextExecutionTime = currentTimeMillis + this.interval;
                try {
                    this.result = this.callable.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
            return this.result;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.cancelled || this.result != null;
        }
    }
}

