/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.BatchResult;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.orm.ibatis.SqlMapClientCallback;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatisBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(IbatisBatchItemWriter.class);
    private SqlMapClientTemplate sqlMapClientTemplate;
    private String statementId;
    private boolean assertUpdates = true;

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        if (this.sqlMapClientTemplate == null) {
            this.sqlMapClientTemplate = new SqlMapClientTemplate(sqlMapClient);
        }
    }

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.sqlMapClientTemplate = sqlMapClientTemplate;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sqlMapClientTemplate, (String)"A SqlMapClient or a SqlMapClientTemplate is required.");
        Assert.notNull((Object)this.statementId, (String)"A statementId is required.");
    }

    @Override
    public void write(final List<? extends T> items) {
        if (!items.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing batch with " + items.size() + " items."));
            }
            List results = (List)this.sqlMapClientTemplate.execute(new SqlMapClientCallback(){

                public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                    executor.startBatch();
                    for (Object item : items) {
                        executor.update(IbatisBatchItemWriter.this.statementId, item);
                    }
                    try {
                        return executor.executeBatchDetailed();
                    }
                    catch (BatchException e) {
                        throw e.getBatchUpdateException();
                    }
                }
            });
            if (this.assertUpdates) {
                if (results.size() != 1) {
                    throw new InvalidDataAccessResourceUsageException("Batch execution returned invalid results. Expected 1 but number of BatchResult objects returned was " + results.size());
                }
                int[] updateCounts = ((BatchResult)results.get(0)).getUpdateCounts();
                int i = 0;
                while (i < updateCounts.length) {
                    int value = updateCounts[i];
                    if (value == 0) {
                        throw new EmptyResultDataAccessException("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + items.get(i) + "]", 1);
                    }
                    ++i;
                }
            }
        }
    }
}

