/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.context.RepeatContextSupport;

public class CompositeCompletionPolicy
implements CompletionPolicy {
    CompletionPolicy[] policies = new CompletionPolicy[0];

    public void setPolicies(CompletionPolicy[] policies) {
        this.policies = Arrays.asList(policies).toArray(new CompletionPolicy[policies.length]);
    }

    public boolean isComplete(RepeatContext context, RepeatStatus result) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        int i = 0;
        while (i < policies.length) {
            if (policies[i].isComplete(contexts[i], result)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isComplete(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        int i = 0;
        while (i < policies.length) {
            if (policies[i].isComplete(contexts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RepeatContext start(RepeatContext context) {
        ArrayList<RepeatContext> list = new ArrayList<RepeatContext>();
        int i = 0;
        while (i < this.policies.length) {
            list.add(this.policies[i].start(context));
            ++i;
        }
        return new CompositeBatchContext(context, list);
    }

    public void update(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        int i = 0;
        while (i < policies.length) {
            policies[i].update(contexts[i]);
            ++i;
        }
        ((RepeatContextSupport)context).increment();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompositeBatchContext
    extends RepeatContextSupport {
        private RepeatContext[] contexts;
        private CompletionPolicy[] policies;

        public CompositeBatchContext(RepeatContext context, List<RepeatContext> contexts) {
            super(context);
            this.contexts = contexts.toArray(new RepeatContext[contexts.size()]);
            this.policies = CompositeCompletionPolicy.this.policies;
        }
    }
}

