/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.context.RetryContextSupport;

public class CompositeRetryPolicy
implements RetryPolicy {
    RetryPolicy[] policies = new RetryPolicy[0];

    public void setPolicies(RetryPolicy[] policies) {
        this.policies = Arrays.asList(policies).toArray(new RetryPolicy[policies.length]);
    }

    public boolean canRetry(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        int i = 0;
        while (i < contexts.length) {
            if (!policies[i].canRetry(contexts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void close(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        RuntimeException exception = null;
        int i = 0;
        while (i < contexts.length) {
            block4: {
                try {
                    policies[i].close(contexts[i]);
                }
                catch (RuntimeException e) {
                    if (exception != null) break block4;
                    exception = e;
                }
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public RetryContext open(RetryContext parent) {
        ArrayList<RetryContext> list = new ArrayList<RetryContext>();
        int i = 0;
        while (i < this.policies.length) {
            list.add(this.policies[i].open(parent));
            ++i;
        }
        return new CompositeRetryContext(parent, list);
    }

    public void registerThrowable(RetryContext context, Throwable throwable) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        int i = 0;
        while (i < contexts.length) {
            policies[i].registerThrowable(contexts[i], throwable);
            ++i;
        }
        ((RetryContextSupport)context).registerThrowable(throwable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeRetryContext
    extends RetryContextSupport {
        RetryContext[] contexts;
        RetryPolicy[] policies;

        public CompositeRetryContext(RetryContext parent, List<RetryContext> contexts) {
            super(parent);
            this.contexts = contexts.toArray(new RetryContext[0]);
            this.policies = CompositeRetryPolicy.this.policies;
        }
    }
}

