/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractPagingItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private volatile boolean initialized = false;
    private int pageSize = 10;
    private volatile int current = 0;
    private volatile int page = 0;
    protected volatile List<T> results;
    private Object lock = new Object();

    public AbstractPagingItemReader() {
        this.setName(ClassUtils.getShortName(AbstractPagingItemReader.class));
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be greater than zero");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected T doRead() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            int next;
            if (this.results == null || this.current >= this.pageSize) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Reading page " + this.getPage()));
                }
                this.doReadPage();
                ++this.page;
                if (this.current >= this.pageSize) {
                    this.current = 0;
                }
            }
            if ((next = this.current++) < this.results.size()) {
                return this.results.get(next);
            }
            return null;
        }
    }

    protected abstract void doReadPage();

    @Override
    protected void doOpen() throws Exception {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Cannot open an already opened ItemReader, call close first");
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.initialized = false;
            this.current = 0;
            this.page = 0;
            this.results = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.page = itemIndex / this.pageSize;
            this.current = itemIndex % this.pageSize;
        }
        this.doJumpToPage(itemIndex);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Jumping to page " + this.getPage() + " and index " + this.current));
        }
    }

    protected abstract void doJumpToPage(int var1);
}

