/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.ClassUtils;

public class DefaultPropertyEditorRegistrar
implements PropertyEditorRegistrar {
    private Map<Class<?>, PropertyEditor> customEditors;

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        if (this.customEditors != null) {
            for (Map.Entry<Class<?>, PropertyEditor> entry : this.customEditors.entrySet()) {
                registry.registerCustomEditor(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setCustomEditors(Map<?, ? extends PropertyEditor> customEditors) {
        this.customEditors = new HashMap();
        for (Map.Entry<?, PropertyEditor> entry : customEditors.entrySet()) {
            Object key = entry.getKey();
            Class requiredType = null;
            if (key instanceof Class) {
                requiredType = (Class)key;
            } else if (key instanceof String) {
                String className = (String)key;
                requiredType = ClassUtils.resolveClassName((String)className, (ClassLoader)this.getClass().getClassLoader());
            } else {
                throw new IllegalArgumentException("Invalid key [" + key + "] for custom editor: needs to be Class or String.");
            }
            PropertyEditor value = entry.getValue();
            this.customEditors.put(requiredType, value);
        }
    }
}

