/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.config.annotation;

import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.integration.chunk.RemoteChunkingManagerStepBuilderFactory;
import org.springframework.batch.integration.chunk.RemoteChunkingWorkerBuilder;
import org.springframework.batch.integration.partition.RemotePartitioningManagerStepBuilderFactory;
import org.springframework.batch.integration.partition.RemotePartitioningWorkerStepBuilderFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
public class BatchIntegrationConfiguration
implements InitializingBean {
    private final JobExplorer jobExplorer;
    private final JobRepository jobRepository;
    private final PlatformTransactionManager transactionManager;
    private RemoteChunkingManagerStepBuilderFactory remoteChunkingManagerStepBuilderFactory;
    private RemoteChunkingWorkerBuilder remoteChunkingWorkerBuilder;
    private RemotePartitioningManagerStepBuilderFactory remotePartitioningManagerStepBuilderFactory;
    private RemotePartitioningWorkerStepBuilderFactory remotePartitioningWorkerStepBuilderFactory;

    @Autowired
    public BatchIntegrationConfiguration(JobRepository jobRepository, JobExplorer jobExplorer, PlatformTransactionManager transactionManager) {
        this.jobRepository = jobRepository;
        this.jobExplorer = jobExplorer;
        this.transactionManager = transactionManager;
    }

    @Bean
    public RemoteChunkingManagerStepBuilderFactory remoteChunkingManagerStepBuilderFactory() {
        return this.remoteChunkingManagerStepBuilderFactory;
    }

    @Bean
    public <I, O> RemoteChunkingWorkerBuilder<I, O> remoteChunkingWorkerBuilder() {
        return this.remoteChunkingWorkerBuilder;
    }

    @Bean
    public RemotePartitioningManagerStepBuilderFactory remotePartitioningManagerStepBuilderFactory() {
        return this.remotePartitioningManagerStepBuilderFactory;
    }

    @Bean
    public RemotePartitioningWorkerStepBuilderFactory remotePartitioningWorkerStepBuilderFactory() {
        return this.remotePartitioningWorkerStepBuilderFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.remoteChunkingManagerStepBuilderFactory = new RemoteChunkingManagerStepBuilderFactory(this.jobRepository, this.transactionManager);
        this.remoteChunkingWorkerBuilder = new RemoteChunkingWorkerBuilder();
        this.remotePartitioningManagerStepBuilderFactory = new RemotePartitioningManagerStepBuilderFactory(this.jobRepository, this.jobExplorer);
        this.remotePartitioningWorkerStepBuilderFactory = new RemotePartitioningWorkerStepBuilderFactory(this.jobRepository, this.jobExplorer);
    }
}

