/*
 * Copyright 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.batch.sample.dao;

import org.springframework.batch.sample.domain.CustomerDebit;
import org.springframework.jdbc.core.JdbcOperations;


/**
 * Reduces customer's credit by the provided amount.
 * 
 * @author Robert Kasanicky
 */
public class JdbcCustomerDebitDao implements CustomerDebitDao {
	
    private static final String UPDATE_CREDIT = "UPDATE customer SET credit= credit-? WHERE name=?";
    
    private JdbcOperations jdbcTemplate;

    public void write(CustomerDebit customerDebit) {
        jdbcTemplate.update(UPDATE_CREDIT,
            new Object[] { customerDebit.getDebit(), customerDebit.getName() });
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

}
