/*
 * Copyright 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.batch.sample.domain;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Person {

	private String title = "";
	private String firstName = "";
	private String last_name = "";
	private int age = 0;
	private Address address = new Address();
	private List children = new ArrayList();
	
	public Person(){
		children.add(new Child());
		children.add(new Child());
	}
	
	/**
	 * @return the address
	 */
	public Address getAddress() {
		return address;
	}
	/**
	 * @param address the address to set
	 */
	public void setAddress(Address address) {
		this.address = address;
	}
	/**
	 * @return the age
	 */
	public int getAge() {
		return age;
	}
	/**
	 * @param age the age to set
	 */
	public void setAge(int age) {
		this.age = age;
	}
	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return firstName;
	}
	/**
	 * @param firstName the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	/**
	 * @return the children
	 */
	public List getChildren() {
		return children;
	}
	/**
	 * @param children the children to set
	 */
	public void setChildren(List children) {
		this.children = children;
	}
	/**
	 * Intentionally non-standard method name for testing purposes
	 * @return the last_name
	 */
	public String getLast_name() {
		return last_name;
	}
	/**
	 * Intentionally non-standard method name for testing purposes
	 * @param last_name the last_name to set
	 */
	public void setLast_name(String last_name) {
		this.last_name = last_name;
	}
	/**
	 * @return the person_title
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * @param title the person title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
    }
	
	public boolean equals(Object o) {
		return EqualsBuilder.reflectionEquals(this, o);
	}

	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}
}
