/*
 * Copyright 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.batch.sample.domain.xml;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * An XML order.
 *
 * This is a complex type.
 */
public class Order {
    private Customer customer;
    private Date date;
    private List lineItems;
    private Shipper shipper;

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List getLineItems() {
        return lineItems;
    }

    public void setLineItems(List lineItems) {
        this.lineItems = lineItems;
    }

    public Shipper getShipper() {
        return shipper;
    }

    public void setShipper(Shipper shipper) {
        this.shipper = shipper;
    }

    public String toString() {
    	return ToStringBuilder.reflectionToString(this);
    }
}
